/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Partitioner;

public class HRegionPartitioner<KEY, VALUE>
extends Partitioner<ImmutableBytesWritable, VALUE>
implements Configurable {
    private final Log LOG = LogFactory.getLog(TableInputFormat.class);
    private Configuration conf = null;
    private HTable table;
    private byte[][] startKeys;

    public int getPartition(ImmutableBytesWritable key, VALUE value, int numPartitions) {
        byte[] region = null;
        if (this.startKeys.length == 1) {
            return 0;
        }
        try {
            region = this.table.getRegionLocation(key.get()).getRegionInfo().getStartKey();
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
        }
        for (int i = 0; i < this.startKeys.length; ++i) {
            if (Bytes.compareTo(region, this.startKeys[i]) != 0) continue;
            if (i >= numPartitions - 1) {
                return (Integer.toString(i).hashCode() & Integer.MAX_VALUE) % numPartitions;
            }
            return i;
        }
        return 0;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        try {
            this.table = new HTable(new HBaseConfiguration(this.conf), configuration.get("hbase.mapred.outputtable"));
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
        }
        try {
            this.startKeys = this.table.getStartKeys();
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
        }
    }
}

