/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class RowCounter {
    static final String NAME = "rowcounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Job job = new Job(conf, "rowcounter_" + tableName);
        job.setJarByClass(RowCounter.class);
        StringBuilder sb = new StringBuilder();
        boolean columnoffset = true;
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        Scan scan = new Scan();
        if (sb.length() > 0) {
            scan.addColumns(sb.toString());
        }
        scan.setFilter(new FirstKeyOnlyFilter());
        TableMapReduceUtil.initTableMapperJob(tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    public static void main(String[] args) throws Exception {
        Job job;
        HBaseConfiguration conf = new HBaseConfiguration();
        String[] otherArgs = new GenericOptionsParser((Configuration)conf, args).getRemainingArgs();
        if (otherArgs.length < 1) {
            System.err.println("ERROR: Wrong number of parameters: " + args.length);
            System.err.println("Usage: RowCounter <tablename> [<column1> <column2>...]");
            System.exit(-1);
        }
        System.exit((job = RowCounter.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            for (KeyValue value : values.list()) {
                if (value.getValue().length <= 0) continue;
                context.getCounter((Enum)Counters.ROWS).increment(1L);
                break;
            }
        }

        private static enum Counters {
            ROWS;

        }
    }
}

