/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWrapper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZKMasterAddressWatcher
implements Watcher {
    private static final Log LOG = LogFactory.getLog(ZKMasterAddressWatcher.class);
    private final ZooKeeperWrapper zooKeeper;
    private final HMaster master;

    public ZKMasterAddressWatcher(HMaster master) {
        this.master = master;
        this.zooKeeper = master.getZooKeeperWrapper();
    }

    public synchronized void process(WatchedEvent event) {
        Watcher.Event.EventType type = event.getType();
        LOG.debug((Object)("Got event " + type + " with path " + event.getPath()));
        if (type.equals((Object)Watcher.Event.EventType.NodeDeleted)) {
            if (event.getPath().equals(this.zooKeeper.clusterStateZNode)) {
                LOG.info((Object)"The cluster was shutdown while waiting, shutting down this master.");
                this.master.shutdownRequested.set(true);
            } else {
                LOG.debug((Object)"Master address ZNode deleted, notifying waiting masters");
                this.notifyAll();
            }
        } else if (type.equals((Object)Watcher.Event.EventType.NodeCreated) && event.getPath().equals(this.zooKeeper.clusterStateZNode)) {
            LOG.debug((Object)"Resetting the watch on the cluster state node.");
            this.zooKeeper.setClusterStateWatch(this);
        }
    }

    public synchronized void waitForMasterAddressAvailability() {
        while (this.zooKeeper.readMasterAddress(this) != null) {
            try {
                LOG.debug((Object)"Waiting for master address ZNode to be deleted and watching the cluster state node");
                this.zooKeeper.setClusterStateWatch(this);
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

