/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class GetDeleteTracker
implements DeleteTracker {
    private static long UNSET = -1L;
    private long familyStamp = UNSET;
    protected List<Delete> deletes = null;
    private List<Delete> newDeletes = new ArrayList<Delete>();
    private Iterator<Delete> iterator;
    private Delete delete = null;

    @Override
    public void add(byte[] buffer, int qualifierOffset, int qualifierLength, long timestamp, byte type) {
        if (type == KeyValue.Type.DeleteFamily.getCode()) {
            if (timestamp > this.familyStamp) {
                this.familyStamp = timestamp;
            }
            return;
        }
        if (timestamp > this.familyStamp) {
            this.newDeletes.add(new Delete(buffer, qualifierOffset, qualifierLength, type, timestamp));
        }
    }

    @Override
    public boolean isDeleted(byte[] buffer, int qualifierOffset, int qualifierLength, long timestamp) {
        if (timestamp <= this.familyStamp) {
            return true;
        }
        if (this.delete == null) {
            return false;
        }
        int ret = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.delete.buffer, this.delete.qualifierOffset, this.delete.qualifierLength);
        while (ret != 0) {
            if (ret <= -1) {
                return false;
            }
            if (ret < 1) continue;
            if (!this.iterator.hasNext()) {
                this.delete = null;
                return false;
            }
            this.delete = this.iterator.next();
            ret = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.delete.buffer, this.delete.qualifierOffset, this.delete.qualifierLength);
        }
        if (timestamp > this.delete.timestamp) {
            return false;
        }
        switch (KeyValue.Type.codeToType(this.delete.type)) {
            case Delete: {
                boolean equal = timestamp == this.delete.timestamp;
                this.delete = this.iterator.hasNext() ? this.iterator.next() : null;
                if (equal) {
                    return true;
                }
                return this.isDeleted(buffer, qualifierOffset, qualifierLength, timestamp);
            }
            case DeleteColumn: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.familyStamp == UNSET && this.delete == null && this.newDeletes.isEmpty();
    }

    @Override
    public void reset() {
        this.deletes = null;
        this.delete = null;
        this.newDeletes = new ArrayList<Delete>();
        this.familyStamp = UNSET;
        this.iterator = null;
    }

    @Override
    public void update() {
        if (this.deletes == null || this.deletes.size() == 0) {
            this.finalize(this.newDeletes);
            return;
        }
        if (this.newDeletes.size() == 0) {
            return;
        }
        ArrayList<Delete> mergeDeletes = new ArrayList<Delete>(this.newDeletes.size());
        int oldIndex = 0;
        int newIndex = 0;
        Delete newDelete = this.newDeletes.get(oldIndex);
        Delete oldDelete = this.deletes.get(oldIndex);
        while (true) {
            switch (this.compareDeletes(oldDelete, newDelete)) {
                case NEXT_NEW: {
                    if (++newIndex == this.newDeletes.size()) {
                        this.mergeDown(mergeDeletes, this.deletes, oldIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    newDelete = this.newDeletes.get(newIndex);
                    break;
                }
                case INCLUDE_NEW_NEXT_NEW: {
                    mergeDeletes.add(newDelete);
                    if (++newIndex == this.newDeletes.size()) {
                        this.mergeDown(mergeDeletes, this.deletes, oldIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    newDelete = this.newDeletes.get(newIndex);
                    break;
                }
                case INCLUDE_NEW_NEXT_BOTH: {
                    mergeDeletes.add(newDelete);
                    ++newIndex;
                    if (++oldIndex == this.deletes.size()) {
                        if (newIndex == this.newDeletes.size()) {
                            this.finalize(mergeDeletes);
                            return;
                        }
                        this.mergeDown(mergeDeletes, this.newDeletes, newIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    if (newIndex == this.newDeletes.size()) {
                        this.mergeDown(mergeDeletes, this.deletes, oldIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    oldDelete = this.deletes.get(oldIndex);
                    newDelete = this.newDeletes.get(newIndex);
                    break;
                }
                case INCLUDE_OLD_NEXT_BOTH: {
                    mergeDeletes.add(oldDelete);
                    ++newIndex;
                    if (++oldIndex == this.deletes.size()) {
                        if (newIndex == this.newDeletes.size()) {
                            this.finalize(mergeDeletes);
                            return;
                        }
                        this.mergeDown(mergeDeletes, this.newDeletes, newIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    if (newIndex == this.newDeletes.size()) {
                        this.mergeDown(mergeDeletes, this.deletes, oldIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    oldDelete = this.deletes.get(oldIndex);
                    newDelete = this.newDeletes.get(newIndex);
                    break;
                }
                case INCLUDE_OLD_NEXT_OLD: {
                    mergeDeletes.add(oldDelete);
                    if (++oldIndex == this.deletes.size()) {
                        this.mergeDown(mergeDeletes, this.newDeletes, newIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    oldDelete = this.deletes.get(oldIndex);
                    break;
                }
                case NEXT_OLD: {
                    if (++oldIndex == this.deletes.size()) {
                        this.mergeDown(mergeDeletes, this.newDeletes, newIndex);
                        this.finalize(mergeDeletes);
                        return;
                    }
                    oldDelete = this.deletes.get(oldIndex);
                }
            }
        }
    }

    private void finalize(List<Delete> mergeDeletes) {
        this.deletes = mergeDeletes;
        this.newDeletes = new ArrayList<Delete>();
        if (this.deletes.size() > 0) {
            this.iterator = this.deletes.iterator();
            this.delete = this.iterator.next();
        }
    }

    private void mergeDown(List<Delete> mergeDeletes, List<Delete> srcDeletes, int srcIndex) {
        int index = srcIndex;
        while (index < srcDeletes.size()) {
            mergeDeletes.add(srcDeletes.get(index++));
        }
    }

    protected DeleteTracker.DeleteCompare compareDeletes(Delete oldDelete, Delete newDelete) {
        int ret = Bytes.compareTo(oldDelete.buffer, oldDelete.qualifierOffset, oldDelete.qualifierLength, newDelete.buffer, newDelete.qualifierOffset, newDelete.qualifierLength);
        if (ret <= -1) {
            return DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD;
        }
        if (ret >= 1) {
            return DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW;
        }
        if (oldDelete.type == newDelete.type) {
            if (oldDelete.type == KeyValue.Type.Delete.getCode()) {
                if (oldDelete.timestamp > newDelete.timestamp) {
                    return DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD;
                }
                if (oldDelete.timestamp < newDelete.timestamp) {
                    return DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW;
                }
                return DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_BOTH;
            }
            if (oldDelete.timestamp < newDelete.timestamp) {
                return DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_BOTH;
            }
            return DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_BOTH;
        }
        if (oldDelete.type < newDelete.type) {
            if (oldDelete.timestamp > newDelete.timestamp) {
                return DeleteTracker.DeleteCompare.INCLUDE_OLD_NEXT_OLD;
            }
            if (oldDelete.timestamp < newDelete.timestamp) {
                return DeleteTracker.DeleteCompare.NEXT_OLD;
            }
            return DeleteTracker.DeleteCompare.NEXT_OLD;
        }
        if (oldDelete.type > newDelete.type) {
            if (oldDelete.timestamp > newDelete.timestamp) {
                return DeleteTracker.DeleteCompare.NEXT_NEW;
            }
            if (oldDelete.timestamp < newDelete.timestamp) {
                return DeleteTracker.DeleteCompare.INCLUDE_NEW_NEXT_NEW;
            }
            return DeleteTracker.DeleteCompare.NEXT_NEW;
        }
        throw new RuntimeException("GetDeleteTracker:compareDelete reached terminal state");
    }

    protected static class Delete {
        byte[] buffer;
        int qualifierOffset;
        int qualifierLength;
        byte type;
        long timestamp;

        public Delete(byte[] buffer, int qualifierOffset, int qualifierLength, byte type, long timestamp) {
            this.buffer = buffer;
            this.qualifierOffset = qualifierOffset;
            this.qualifierLength = qualifierLength;
            this.type = type;
            this.timestamp = timestamp;
        }
    }
}

