/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HLogKey;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MinorCompactingStoreScanner;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileGetScan;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

public class Store
implements HConstants,
HeapSize {
    static final Log LOG = LogFactory.getLog(Store.class);
    protected final MemStore memstore;
    private final Path homedir;
    private final HRegion region;
    private final HColumnDescriptor family;
    final FileSystem fs;
    private final HBaseConfiguration conf;
    protected long ttl;
    private long majorCompactionTime;
    private int maxFilesToCompact;
    private final long desiredMaxFileSize;
    private volatile long storeSize = 0L;
    private final Object flushLock = new Object();
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final byte[] storeName;
    private final String storeNameStr;
    private final boolean inMemory;
    private final NavigableMap<Long, StoreFile> storefiles = new ConcurrentSkipListMap<Long, StoreFile>();
    private final CopyOnWriteArraySet<ChangedReadersObserver> changedReaderObservers = new CopyOnWriteArraySet();
    private volatile long maxSeqId = -1L;
    private long maxSeqIdBeforeLogRecovery = -1L;
    private final Path regionCompactionDir;
    private final Object compactLock = new Object();
    private final int compactionThreshold;
    private final int blocksize;
    private final boolean blockcache;
    private final Compression.Algorithm compression;
    final KeyValue.KVComparator comparator;
    final KeyValue.KVComparator comparatorIgnoringType;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 17 * ClassSize.REFERENCE + 48 + 12 + 1 + ClassSize.align(ClassSize.ARRAY));
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT);

    protected Store(Path basedir, HRegion region, HColumnDescriptor family, FileSystem fs, Path reconstructionLog, HBaseConfiguration conf, Progressable reporter) throws IOException {
        HRegionInfo info = region.regionInfo;
        this.homedir = Store.getStoreHomedir(basedir, info.getEncodedName(), family.getName());
        this.region = region;
        this.family = family;
        this.fs = fs;
        this.conf = conf;
        this.blockcache = family.isBlockCacheEnabled();
        this.blocksize = family.getBlocksize();
        this.compression = family.getCompression();
        this.comparator = info.getComparator();
        this.comparatorIgnoringType = this.comparator.getComparatorIgnoringType();
        this.ttl = family.getTimeToLive();
        this.ttl = this.ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (this.ttl == -1L ? Long.MAX_VALUE : (this.ttl *= 1000L));
        this.memstore = new MemStore(this.comparator);
        this.regionCompactionDir = new Path(HRegion.getCompactionDir(basedir), Integer.toString(info.getEncodedName()));
        this.storeName = this.family.getName();
        this.storeNameStr = Bytes.toString(this.storeName);
        this.compactionThreshold = conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.inMemory = family.isInMemory();
        long maxFileSize = info.getTableDesc().getMaxFileSize();
        if (maxFileSize == 0x10000000L) {
            maxFileSize = conf.getLong("hbase.hregion.max.filesize", 0x10000000L);
        }
        this.desiredMaxFileSize = maxFileSize;
        this.majorCompactionTime = conf.getLong("hbase.hregion.majorcompaction", 86400000L);
        if (family.getValue("hbase.hregion.majorcompaction") != null) {
            String strCompactionTime = family.getValue("hbase.hregion.majorcompaction");
            this.majorCompactionTime = new Long(strCompactionTime);
        }
        this.maxFilesToCompact = conf.getInt("hbase.hstore.compaction.max", 10);
        this.storefiles.putAll(this.loadStoreFiles());
        this.maxSeqIdBeforeLogRecovery = this.maxSeqId;
        long newId = this.runReconstructionLog(reconstructionLog, this.maxSeqId, reporter);
        if (newId != -1L) {
            this.maxSeqId = newId;
        }
    }

    HColumnDescriptor getFamily() {
        return this.family;
    }

    long getMaxSequenceId() {
        return this.maxSeqId;
    }

    long getMaxSeqIdBeforeLogRecovery() {
        return this.maxSeqIdBeforeLogRecovery;
    }

    public static Path getStoreHomedir(Path tabledir, int encodedName, byte[] family) {
        return new Path(tabledir, new Path(Integer.toString(encodedName), new Path(Bytes.toString(family))));
    }

    private long runReconstructionLog(Path reconstructionLog, long msid, Progressable reporter) throws IOException {
        try {
            return this.doReconstructionLog(reconstructionLog, msid, reporter);
        }
        catch (EOFException e) {
            LOG.warn((Object)("Exception processing reconstruction log " + reconstructionLog + " opening " + Bytes.toString(this.storeName) + " -- continuing.  Probably lack-of-HADOOP-1700 causing DATA LOSS!"), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)("Exception processing reconstruction log " + reconstructionLog + " opening " + Bytes.toString(this.storeName)), (Throwable)e);
            throw e;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doReconstructionLog(Path reconstructionLog, long maxSeqID, Progressable reporter) throws UnsupportedEncodingException, IOException {
        if (reconstructionLog == null || !this.fs.exists(reconstructionLog)) {
            return -1L;
        }
        FileStatus[] stats = this.fs.listStatus(reconstructionLog);
        if (stats == null || stats.length == 0) {
            LOG.warn((Object)("Passed reconstruction log " + reconstructionLog + " is zero-length"));
            return -1L;
        }
        long maxSeqIdInLog = -1L;
        long firstSeqIdInLog = -1L;
        KeyValueSkipListSet reconstructedCache = new KeyValueSkipListSet(this.comparator);
        SequenceFile.Reader logReader = new SequenceFile.Reader(this.fs, reconstructionLog, (Configuration)this.conf);
        try {
            HLogKey key = HLog.newKey(this.conf);
            KeyValue val = new KeyValue();
            long skippedEdits = 0L;
            long editsCount = 0L;
            int reportInterval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
            while (logReader.next((Writable)key, (Writable)val)) {
                if (firstSeqIdInLog == -1L) {
                    firstSeqIdInLog = key.getLogSeqNum();
                }
                maxSeqIdInLog = Math.max(maxSeqIdInLog, key.getLogSeqNum());
                if (key.getLogSeqNum() <= maxSeqID) {
                    ++skippedEdits;
                    continue;
                }
                if (val.matchingFamily(HLog.METAFAMILY) || !Bytes.equals(key.getRegionName(), this.region.regionInfo.getRegionName()) || !val.matchingFamily(this.family.getName())) continue;
                reconstructedCache.add(val);
                if (reporter != null && ++editsCount % (long)reportInterval == 0L) {
                    reporter.progress();
                }
                val = new KeyValue();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Applied " + editsCount + ", skipped " + skippedEdits + "; store maxSeqID=" + maxSeqID + ", firstSeqIdInLog=" + firstSeqIdInLog + ", maxSeqIdInLog=" + maxSeqIdInLog));
            }
        }
        finally {
            logReader.close();
        }
        if (reconstructedCache.size() > 0) {
            long newFileSeqNo;
            StoreFile sf;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"flushing reconstructionCache");
            }
            if ((sf = this.internalFlushCache(reconstructedCache, newFileSeqNo = maxSeqIdInLog + 1L)) == null) {
                throw new IOException("Flush failed with a null store file");
            }
            this.storefiles.put(newFileSeqNo, sf);
            this.notifyChangedReadersObservers();
            return newFileSeqNo;
        }
        return -1L;
    }

    private Map<Long, StoreFile> loadStoreFiles() throws IOException {
        HashMap<Long, StoreFile> results = new HashMap<Long, StoreFile>();
        FileStatus[] files = this.fs.listStatus(this.homedir);
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDir()) continue;
            Path p = files[i].getPath();
            if (this.fs.getFileStatus(p).getLen() <= 0L) {
                LOG.warn((Object)("Skipping " + p + " because its empty. HBASE-646 DATA LOSS?"));
                continue;
            }
            StoreFile curfile = null;
            try {
                curfile = new StoreFile(this.fs, p, this.blockcache, this.conf, this.inMemory);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Failed open of " + p + "; presumption is that file was " + "corrupted at flush and lost edits picked up by commit log replay. " + "Verify!"), (Throwable)ioe);
                continue;
            }
            long storeSeqId = curfile.getMaxSequenceId();
            if (storeSeqId > this.maxSeqId) {
                this.maxSeqId = storeSeqId;
            }
            long length = curfile.getReader().length();
            this.storeSize += length;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loaded " + FSUtils.getPath(p) + ", isReference=" + curfile.isReference() + ", sequence id=" + storeSeqId + ", length=" + length + ", majorCompaction=" + curfile.isMajorCompaction()));
            }
            results.put(storeSeqId, curfile);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long add(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.add(kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long delete(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.delete(kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    NavigableMap<Long, StoreFile> getStorefiles() {
        return this.storefiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StoreFile> close() throws IOException {
        this.lock.writeLock().lock();
        try {
            ArrayList<StoreFile> result = new ArrayList<StoreFile>(this.storefiles.values());
            this.storefiles.clear();
            for (StoreFile f : result) {
                f.close();
            }
            LOG.debug((Object)("closed " + this.storeNameStr));
            ArrayList<StoreFile> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void snapshot() {
        this.memstore.snapshot();
    }

    private StoreFile flushCache(long logCacheFlushId, SortedSet<KeyValue> snapshot) throws IOException {
        return this.internalFlushCache(snapshot, logCacheFlushId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFile internalFlushCache(SortedSet<KeyValue> set, long logCacheFlushId) throws IOException {
        HFile.Writer writer = null;
        long flushed = 0L;
        if (set.size() == 0) {
            return null;
        }
        long oldestTimestamp = System.currentTimeMillis() - this.ttl;
        Object object = this.flushLock;
        synchronized (object) {
            writer = this.getWriter();
            int entries = 0;
            try {
                for (KeyValue kv : set) {
                    if (Store.isExpired(kv, oldestTimestamp)) continue;
                    writer.append(kv);
                    ++entries;
                    flushed += this.memstore.heapSizeChange(kv, true);
                }
            }
            finally {
                StoreFile.appendMetadata(writer, logCacheFlushId);
                writer.close();
            }
        }
        StoreFile sf = new StoreFile(this.fs, writer.getPath(), this.blockcache, this.conf, this.inMemory);
        HFile.Reader r = sf.getReader();
        this.storeSize += r.length();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", memsize=" + StringUtils.humanReadableInt((long)flushed) + ", filesize=" + StringUtils.humanReadableInt((long)r.length()) + " to " + this.region.regionInfo.getRegionNameAsString()));
        }
        return sf;
    }

    HFile.Writer getWriter() throws IOException {
        return this.getWriter(this.homedir);
    }

    private HFile.Writer getWriter(Path basedir) throws IOException {
        return StoreFile.getWriter(this.fs, basedir, this.blocksize, this.compression, this.comparator.getRawComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(long logCacheFlushId, StoreFile sf, SortedSet<KeyValue> set) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storefiles.put(logCacheFlushId, sf);
            this.notifyChangedReadersObservers();
            this.memstore.clearSnapshot(set);
            boolean bl = this.storefiles.size() >= this.compactionThreshold;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void notifyChangedReadersObservers() throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            o.updateReaders();
        }
    }

    void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    void deleteChangedReaderObserver(ChangedReadersObserver o) {
        if (this.changedReaderObservers.size() > 0 && !this.changedReaderObservers.remove(o)) {
            LOG.warn((Object)("Not in set" + o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreSize compact(boolean mc) throws IOException {
        boolean forceSplit = this.region.shouldSplit(false);
        boolean majorcompaction = mc;
        Object object = this.compactLock;
        synchronized (object) {
            ArrayList<StoreFile> filesToCompact = new ArrayList<StoreFile>(this.storefiles.values());
            if (filesToCompact.isEmpty()) {
                LOG.debug((Object)(this.storeNameStr + ": no store files to compact"));
                return null;
            }
            long maxId = (Long)this.storefiles.lastKey();
            if (!majorcompaction) {
                majorcompaction = this.isMajorCompaction(filesToCompact);
            }
            boolean references = this.hasReferences(filesToCompact);
            if (!(majorcompaction || references || !forceSplit && filesToCompact.size() >= this.compactionThreshold)) {
                return this.checkSplit(forceSplit);
            }
            if (!this.fs.exists(this.regionCompactionDir) && !this.fs.mkdirs(this.regionCompactionDir)) {
                LOG.warn((Object)("Mkdir on " + this.regionCompactionDir.toString() + " failed"));
                return this.checkSplit(forceSplit);
            }
            int countOfFiles = filesToCompact.size();
            long totalSize = 0L;
            long[] fileSizes = new long[countOfFiles];
            long skipped = 0L;
            int point = 0;
            for (int i = 0; i < countOfFiles; ++i) {
                long len;
                StoreFile file = (StoreFile)filesToCompact.get(i);
                Path path = file.getPath();
                if (path == null) {
                    LOG.warn((Object)("Path is null for " + file));
                    return null;
                }
                HFile.Reader r = file.getReader();
                if (r == null) {
                    LOG.warn((Object)("StoreFile " + file + " has a null Reader"));
                    continue;
                }
                fileSizes[i] = len = file.getReader().length();
                totalSize += len;
            }
            if (!majorcompaction && !references) {
                for (point = 0; point < countOfFiles - 1 && (fileSizes[point] >= fileSizes[point + 1] * 2L || countOfFiles - point > this.maxFilesToCompact); ++point) {
                    skipped += fileSizes[point];
                }
                if ((filesToCompact = new ArrayList(filesToCompact.subList(point, countOfFiles))).size() <= 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Skipped compaction of 1 file; compaction size of " + this.storeNameStr + ": " + StringUtils.humanReadableInt((long)totalSize) + "; Skipped " + point + " files, size: " + skipped));
                    }
                    return this.checkSplit(forceSplit);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Compaction size of " + this.storeNameStr + ": " + StringUtils.humanReadableInt((long)totalSize) + "; Skipped " + point + " file(s), size: " + skipped));
                }
            }
            LOG.debug((Object)("Started compaction of " + filesToCompact.size() + " file(s)" + (references ? ", hasReferences=true," : " ") + " into " + FSUtils.getPath(this.regionCompactionDir) + ", seqid=" + maxId));
            HFile.Writer writer = this.compact(filesToCompact, majorcompaction, maxId);
            StoreFile sf = this.completeCompaction(filesToCompact, writer);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Completed" + (majorcompaction ? " major " : " ") + "compaction of " + this.storeNameStr + "; new storefile is " + (sf == null ? "none" : sf.toString()) + "; store size is " + StringUtils.humanReadableInt((long)this.storeSize)));
            }
        }
        return this.checkSplit(forceSplit);
    }

    private boolean hasReferences(Collection<StoreFile> files) {
        if (files != null && files.size() > 0) {
            for (StoreFile hsf : files) {
                if (!hsf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    private static long getLowestTimestamp(FileSystem fs, Path dir) throws IOException {
        FileStatus[] stats = fs.listStatus(dir);
        if (stats == null || stats.length == 0) {
            return 0L;
        }
        long lowTimestamp = Long.MAX_VALUE;
        for (int i = 0; i < stats.length; ++i) {
            long timestamp = stats[i].getModificationTime();
            if (timestamp >= lowTimestamp) continue;
            lowTimestamp = timestamp;
        }
        return lowTimestamp;
    }

    boolean isMajorCompaction() throws IOException {
        ArrayList<StoreFile> filesToCompact = null;
        filesToCompact = new ArrayList<StoreFile>(this.storefiles.values());
        return this.isMajorCompaction(filesToCompact);
    }

    private boolean isMajorCompaction(List<StoreFile> filesToCompact) throws IOException {
        boolean result = false;
        if (filesToCompact == null || filesToCompact.isEmpty()) {
            return result;
        }
        long lowTimestamp = Store.getLowestTimestamp(this.fs, filesToCompact.get(0).getPath().getParent());
        long now = System.currentTimeMillis();
        if (lowTimestamp > 0L && lowTimestamp < now - this.majorCompactionTime) {
            long elapsedTime = now - lowTimestamp;
            if (filesToCompact.size() == 1 && filesToCompact.get(0).isMajorCompaction() && (this.ttl == Integer.MAX_VALUE || elapsedTime < this.ttl)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipping major compaction of " + this.storeNameStr + " because one (major) compacted file only and elapsedTime " + elapsedTime + "ms is < ttl=" + this.ttl));
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Major compaction triggered on store " + this.storeNameStr + "; time since last major compaction " + (now - lowTimestamp) + "ms"));
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HFile.Writer compact(List<StoreFile> filesToCompact, boolean majorCompaction, long maxId) throws IOException {
        KeyValueScanner[] scanners = new KeyValueScanner[filesToCompact.size()];
        for (int i = 0; i < filesToCompact.size(); ++i) {
            HFile.Reader r = filesToCompact.get(i).getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + filesToCompact.get(i) + " has a null Reader"));
                continue;
            }
            scanners[i] = new StoreFileScanner(r.getScanner(false));
        }
        HFile.Writer writer = null;
        try {
            InternalScanner scanner;
            if (majorCompaction) {
                scanner = null;
                try {
                    Scan scan = new Scan();
                    scan.setMaxVersions(this.family.getMaxVersions());
                    scanner = new StoreScanner(this, scan, scanners);
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                    boolean more = true;
                    while (more) {
                        more = scanner.next(kvs);
                        for (KeyValue kv : kvs) {
                            if (writer == null) {
                                writer = this.getWriter(this.regionCompactionDir);
                            }
                            writer.append(kv);
                        }
                        kvs.clear();
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            scanner = null;
            try {
                scanner = new MinorCompactingStoreScanner(this, scanners);
                writer = this.getWriter(this.regionCompactionDir);
                while (((MinorCompactingStoreScanner)scanner).next(writer)) {
                }
            }
            finally {
                if (scanner != null) {
                    ((MinorCompactingStoreScanner)scanner).close();
                }
            }
            if (writer == null) return writer;
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            StoreFile.appendMetadata(writer, maxId, majorCompaction);
            writer.close();
            throw throwable;
        }
        StoreFile.appendMetadata(writer, maxId, majorCompaction);
        writer.close();
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFile completeCompaction(List<StoreFile> compactedFiles, HFile.Writer compactedFile) throws IOException {
        StoreFile result = null;
        if (compactedFile != null) {
            Path p = null;
            try {
                p = StoreFile.rename(this.fs, compactedFile.getPath(), StoreFile.getRandomFilename(this.fs, this.homedir));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed move of compacted file " + compactedFile.getPath()), (Throwable)e);
                return null;
            }
            result = new StoreFile(this.fs, p, this.blockcache, this.conf, this.inMemory);
        }
        this.lock.writeLock().lock();
        try {
            try {
                for (Map.Entry e : this.storefiles.entrySet()) {
                    if (!compactedFiles.contains(e.getValue())) continue;
                    this.storefiles.remove(e.getKey());
                }
                if (result != null) {
                    Long orderVal = result.getMaxSequenceId();
                    this.storefiles.put(orderVal, result);
                }
                this.notifyChangedReadersObservers();
                for (StoreFile hsf : compactedFiles) {
                    hsf.delete();
                }
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException(e);
                LOG.error((Object)("Failed replacing compacted files in " + this.storeNameStr + ". Compacted file is " + (result == null ? "none" : result.toString()) + ".  Files replaced " + compactedFiles.toString() + " some of which may have been already removed"), (Throwable)e);
            }
            this.storeSize = 0L;
            for (StoreFile hsf : this.storefiles.values()) {
                HFile.Reader r = hsf.getReader();
                if (r == null) {
                    LOG.warn((Object)("StoreFile " + hsf + " has a null Reader"));
                    continue;
                }
                this.storeSize += r.length();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    public int getNumberOfstorefiles() {
        return this.storefiles.size();
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.family.getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    static void expiredOrDeleted(Set<KeyValue> set, KeyValue kv) {
        boolean b = set.remove(kv);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(kv.toString() + " expired: " + b));
        }
    }

    static boolean isExpired(KeyValue key, long oldestTimestamp) {
        return key.getTimestamp() < oldestTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyValue getRowKeyAtOrBefore(KeyValue kv) throws IOException {
        GetClosestRowBeforeTracker state = new GetClosestRowBeforeTracker(this.comparator, kv, this.ttl, this.region.getRegionInfo().isMetaRegion());
        this.lock.readLock().lock();
        try {
            this.memstore.getRowKeyAtOrBefore(state);
            NavigableMap<Long, StoreFile> m = this.storefiles.descendingMap();
            for (Map.Entry e : m.entrySet()) {
                this.rowAtOrBeforeFromStoreFile((StoreFile)e.getValue(), state);
            }
            KeyValue keyValue = state.getCandidate();
            return keyValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void rowAtOrBeforeFromStoreFile(StoreFile f, GetClosestRowBeforeTracker state) throws IOException {
        KeyValue kv;
        HFileScanner scanner;
        KeyValue firstOnRow;
        HFile.Reader r = f.getReader();
        if (r == null) {
            LOG.warn((Object)("StoreFile " + f + " has a null Reader"));
            return;
        }
        byte[] fk = r.getFirstKey();
        KeyValue firstKV = KeyValue.createKeyValueFromKey(fk, 0, fk.length);
        byte[] lk = r.getLastKey();
        KeyValue lastKV = KeyValue.createKeyValueFromKey(lk, 0, lk.length);
        if (this.comparator.compareRows(lastKV, firstOnRow = state.getTargetKey()) < 0) {
            if (!state.isTargetTable(lastKV)) {
                return;
            }
            firstOnRow = new KeyValue(lastKV.getRow(), Long.MAX_VALUE);
        }
        if (!this.seekToScanner(scanner = r.getScanner(), firstOnRow, firstKV)) {
            return;
        }
        if (this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
            return;
        }
        while (scanner.seekBefore(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength()) && state.isTargetTable(kv = scanner.getKeyValue()) && state.isBetterCandidate(kv) && this.seekToScanner(scanner, firstOnRow = new KeyValue(kv.getRow(), Long.MAX_VALUE), firstKV) && !this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
        }
    }

    private boolean seekToScanner(HFileScanner scanner, KeyValue firstOnRow, KeyValue firstKV) throws IOException {
        int result;
        KeyValue kv = firstOnRow;
        if (this.comparator.compareRows(firstKV, firstOnRow) == 0) {
            kv = firstKV;
        }
        return (result = scanner.seekTo(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength())) >= 0;
    }

    private boolean walkForwardInSingleRow(HFileScanner scanner, KeyValue firstOnRow, GetClosestRowBeforeTracker state) throws IOException {
        boolean foundCandidate = false;
        do {
            KeyValue kv;
            if (this.comparator.compareRows(kv = scanner.getKeyValue(), firstOnRow) < 0) continue;
            if (state.isTooFar(kv, firstOnRow)) break;
            if (state.isExpired(kv) || !state.handle(kv)) continue;
            foundCandidate = true;
            break;
        } while (scanner.next());
        return foundCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreSize checkSplit(boolean force) {
        this.lock.readLock().lock();
        try {
            StoreFile sf;
            if (this.storefiles.isEmpty()) {
                StoreSize storeSize = null;
                return storeSize;
            }
            if (!force && this.storeSize < this.desiredMaxFileSize) {
                StoreSize storeSize = null;
                return storeSize;
            }
            boolean splitable = true;
            long maxSize = 0L;
            Long mapIndex = 0L;
            for (Map.Entry e : this.storefiles.entrySet()) {
                HFile.Reader r;
                sf = (StoreFile)e.getValue();
                if (splitable) {
                    boolean bl = splitable = !sf.isReference();
                    if (!splitable) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(sf + " is not splittable"));
                        }
                        StoreSize storeSize = null;
                        return storeSize;
                    }
                }
                if ((r = sf.getReader()) == null) {
                    LOG.warn((Object)("Storefile " + sf + " Reader is null"));
                    continue;
                }
                long size = r.length();
                if (size <= maxSize) continue;
                maxSize = size;
                mapIndex = (Long)e.getKey();
            }
            StoreFile sf2 = (StoreFile)this.storefiles.get(mapIndex);
            HFile.Reader r = sf2.getReader();
            if (r == null) {
                LOG.warn((Object)("Storefile " + sf2 + " Reader is null"));
                sf = null;
                return sf;
            }
            byte[] midkey = r.midkey();
            if (midkey != null) {
                KeyValue mk = KeyValue.createKeyValueFromKey(midkey, 0, midkey.length);
                byte[] fk = r.getFirstKey();
                KeyValue firstKey = KeyValue.createKeyValueFromKey(fk, 0, fk.length);
                byte[] lk = r.getLastKey();
                KeyValue lastKey = KeyValue.createKeyValueFromKey(lk, 0, lk.length);
                if (this.comparator.compareRows(mk, firstKey) == 0 && this.comparator.compareRows(mk, lastKey) == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"cannot split because midkey is the same as first or last row");
                    }
                    StoreSize storeSize = null;
                    return storeSize;
                }
                StoreSize storeSize = new StoreSize(maxSize, mk.getRow());
                return storeSize;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed getting store size for " + this.storeNameStr), (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    public long getSize() {
        return this.storeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols) {
        this.lock.readLock().lock();
        try {
            StoreScanner storeScanner = new StoreScanner(this, scan, targetCols);
            return storeScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.storeNameStr;
    }

    int getStorefilesCount() {
        return this.storefiles.size();
    }

    long getStorefilesSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles.values()) {
            HFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.length();
        }
        return size;
    }

    long getStorefilesIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storefiles.values()) {
            HFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.indexSize();
        }
        return size;
    }

    HRegion getHRegion() {
        return this.region;
    }

    HRegionInfo getHRegionInfo() {
        return this.region.regionInfo;
    }

    static boolean getClosest(HFileScanner s, KeyValue kv) throws IOException {
        int result = s.seekTo(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
        return !(result < 0 ? !s.seekTo() : result > 0 && !s.next());
    }

    static boolean matchingColumns(KeyValue kv, Set<byte[]> columns) {
        if (columns == null) {
            return true;
        }
        if (columns.size() > 100) {
            return columns.contains(kv.getColumn());
        }
        for (byte[] column : columns) {
            if (!kv.matchingColumn(column)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(Get get2, NavigableSet<byte[]> columns, List<KeyValue> result) throws IOException {
        KeyValue.KeyComparator keyComparator = this.comparator.getRawComparator();
        QueryMatcher matcher = new QueryMatcher(get2, this.family.getName(), columns, this.ttl, keyComparator, this.versionsToReturn(get2.getMaxVersions()));
        this.lock.readLock().lock();
        try {
            if (this.memstore.get(matcher, result)) {
                return;
            }
            if (this.storefiles.isEmpty()) {
                return;
            }
            ArrayList<HFileScanner> storefileScanners = new ArrayList<HFileScanner>();
            for (StoreFile sf : this.storefiles.descendingMap().values()) {
                HFile.Reader r = sf.getReader();
                if (r == null) {
                    LOG.warn((Object)("StoreFile " + sf + " has a null Reader"));
                    continue;
                }
                storefileScanners.add(r.getScanner());
            }
            StoreFileGetScan scanner = new StoreFileGetScan(storefileScanners, matcher);
            scanner.get(result);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateColumnValue(byte[] row, byte[] f, byte[] qualifier, long newValue) throws IOException {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        KeyValue.KeyComparator keyComparator = this.comparator.getRawComparator();
        KeyValue kv = null;
        Get get2 = new Get(row);
        TreeSet<byte[]> qualifiers = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        qualifiers.add(qualifier);
        QueryMatcher matcher = new QueryMatcher(get2, f, qualifiers, this.ttl, keyComparator, 1);
        this.lock.readLock().lock();
        this.memstore.readLockLock();
        try {
            int memstoreCode = this.memstore.getWithCode(matcher, result);
            if (memstoreCode != 0) {
                kv = ((KeyValue)result.get(0)).clone();
                byte[] buffer = kv.getBuffer();
                int valueOffset = kv.getValueOffset();
                Bytes.putBytes(buffer, valueOffset, Bytes.toBytes(newValue), 0, 8);
                if (memstoreCode == 2) {
                    long currTs = System.currentTimeMillis();
                    if (currTs == kv.getTimestamp()) {
                        ++currTs;
                    }
                    Bytes.putBytes(buffer, kv.getTimestampOffset(), Bytes.toBytes(currTs), 0, 8);
                }
            } else {
                kv = new KeyValue(row, f, qualifier, System.currentTimeMillis(), Bytes.toBytes(newValue));
            }
            long l = this.add(kv);
            return l;
        }
        finally {
            this.memstore.readLockUnlock();
            this.lock.readLock().unlock();
        }
    }

    public boolean hasTooManyStoreFiles() {
        return this.storefiles.size() > this.compactionThreshold;
    }

    @Override
    public long heapSize() {
        return DEEP_OVERHEAD + this.memstore.heapSize();
    }

    public StoreFlusher getStoreFlusher(long cacheFlushId) {
        return new StoreFlusherImpl(cacheFlushId);
    }

    private class StoreFlusherImpl
    implements StoreFlusher {
        private long cacheFlushId;
        private SortedSet<KeyValue> snapshot;
        private StoreFile storeFile;

        private StoreFlusherImpl(long cacheFlushId) {
            this.cacheFlushId = cacheFlushId;
        }

        @Override
        public void prepare() {
            Store.this.memstore.snapshot();
            this.snapshot = Store.this.memstore.getSnapshot();
        }

        @Override
        public void flushCache() throws IOException {
            this.storeFile = Store.this.flushCache(this.cacheFlushId, this.snapshot);
        }

        @Override
        public boolean commit() throws IOException {
            if (this.storeFile == null) {
                return false;
            }
            return Store.this.updateStorefiles(this.cacheFlushId, this.storeFile, this.snapshot);
        }
    }

    static class StoreSize {
        private final long size;
        private final byte[] row;

        StoreSize(long size, byte[] row) {
            this.size = size;
            this.row = row;
        }

        long getSize() {
            return this.size;
        }

        byte[] getSplitRow() {
            return this.row;
        }
    }
}

