/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class AbstractModel {
    private Log LOG = LogFactory.getLog(AbstractModel.class);
    protected HBaseConfiguration conf;
    protected HBaseAdmin admin;
    protected static final Encodings.Encoding encoding = Encodings.EUTF8;
    protected static final byte COLON = Bytes.toBytes(":")[0];

    public void initialize(HBaseConfiguration conf, HBaseAdmin admin) {
        this.conf = conf;
        this.admin = admin;
    }

    protected byte[][] getColumns(byte[] tableName) throws HBaseRestException {
        try {
            HTable h = new HTable(this.conf, tableName);
            Collection<HColumnDescriptor> columns = h.getTableDescriptor().getFamilies();
            byte[][] resultant = new byte[columns.size()][];
            int count = 0;
            for (HColumnDescriptor c : columns) {
                resultant[count++] = c.getNameWithColon();
            }
            return resultant;
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    protected boolean isColumnFamily(byte[] columnName) {
        for (int i = 0; i < columnName.length; ++i) {
            if (columnName[i] != COLON) continue;
            return true;
        }
        return false;
    }

    protected static class Encodings {
        public static Encoding EBase64 = new Encoding(){

            @Override
            public String encode(byte[] b) throws HBaseRestException {
                return Base64.encodeBytes(b);
            }
        };
        public static Encoding EUTF8 = new Encoding(){

            @Override
            public String encode(byte[] b) throws HBaseRestException {
                return new String(b);
            }
        };

        protected Encodings() {
        }

        protected static interface Encoding {
            public String encode(byte[] var1) throws HBaseRestException;
        }
    }
}

