/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.descriptors.TimestampsDescriptor;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;

public class RowModel
extends AbstractModel {
    private Log LOG = LogFactory.getLog(RowModel.class);

    public RowModel(HBaseConfiguration conf, HBaseAdmin admin) {
        super.initialize(conf, admin);
    }

    @Deprecated
    public RowResult get(byte[] tableName, byte[] rowName) throws HBaseRestException {
        return this.get(tableName, new Get(rowName)).getRowResult();
    }

    public Result get(byte[] tableName, Get get2) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            return table.get(get2);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    @Deprecated
    public RowResult get(byte[] tableName, byte[] rowName, byte[][] columns) throws HBaseRestException {
        Get get2 = new Get(rowName);
        for (byte[] column : columns) {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            get2.addColumn(famAndQf[0], famAndQf[1]);
        }
        return this.get(tableName, get2).getRowResult();
    }

    @Deprecated
    public RowResult get(byte[] tableName, byte[] rowName, byte[][] columns, long timestamp) throws HBaseRestException {
        Get get2 = new Get(rowName);
        for (byte[] column : columns) {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            get2.addColumn(famAndQf[0], famAndQf[1]);
        }
        get2.setTimeStamp(timestamp);
        return this.get(tableName, get2).getRowResult();
    }

    @Deprecated
    public RowResult get(byte[] tableName, byte[] rowName, long timestamp) throws HBaseRestException {
        Get get2 = new Get(rowName);
        get2.setTimeStamp(timestamp);
        return this.get(tableName, get2).getRowResult();
    }

    public TimestampsDescriptor getTimestamps(byte[] tableName, byte[] rowName) throws HBaseRestException {
        throw new HBaseRestException("operation currently unsupported");
    }

    public void post(byte[] tableName, Put put) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            table.put(put);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public void post(byte[] tableName, List<Put> puts) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            table.put(puts);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    @Deprecated
    public void delete(byte[] tableName, byte[] rowName) throws HBaseRestException {
        Delete delete = new Delete(rowName);
        this.delete(tableName, delete);
    }

    @Deprecated
    public void delete(byte[] tableName, byte[] rowName, byte[][] columns) throws HBaseRestException {
        Delete delete = new Delete(rowName);
        for (byte[] column : columns) {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            delete.deleteColumn(famAndQf[0], famAndQf[1]);
        }
        this.delete(tableName, delete);
    }

    public void delete(byte[] tableName, Delete delete) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            table.delete(delete);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }
}

