/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import java.util.HashSet;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.RowFilterSet;
import org.apache.hadoop.hbase.rest.RESTConstants;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.filter.FilterFactory;
import org.apache.hadoop.hbase.rest.filter.FilterFactoryConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RowFilterSetFactory
implements FilterFactory {
    @Override
    public RowFilterInterface getFilterFromJSON(String args) throws HBaseRestException {
        JSONArray filterArray;
        try {
            filterArray = new JSONArray(args);
        }
        catch (JSONException e) {
            throw new HBaseRestException((Exception)((Object)e));
        }
        if (filterArray.length() == 1) {
            return this.getRowFilter(filterArray.optJSONObject(0));
        }
        HashSet<RowFilterInterface> set = new HashSet<RowFilterInterface>();
        for (int i = 0; i < filterArray.length(); ++i) {
            JSONObject filter = filterArray.optJSONObject(i);
            if (filter == null) {
                throw new FilterFactoryConstants.MalformedFilterException();
            }
            set.add(this.getRowFilter(filter));
        }
        return new RowFilterSet(set);
    }

    protected RowFilterInterface getRowFilter(JSONObject filter) throws HBaseRestException {
        String filterType = filter.optString("type");
        if (filterType == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        String filterArgs = filter.optString("args");
        if (filterArgs == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        FilterFactory f = RESTConstants.filterFactories.get(filterType);
        if (f == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        return f.getFilterFromJSON(filterArgs);
    }
}

