/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.thrift.ThriftUtilities;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRegionInfo;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;

public class ThriftServer {
    private static void printUsageAndExit() {
        ThriftServer.printUsageAndExit(null);
    }

    private static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.out.println("Usage: java org.apache.hadoop.hbase.thrift.ThriftServer --help | [--port=PORT] start");
        System.out.println("Arguments:");
        System.out.println(" start Start thrift server");
        System.out.println(" stop  Stop thrift server");
        System.out.println("Options:");
        System.out.println(" port  Port to listen on. Default: 9090");
        System.out.println(" help  Print this message and exit");
        System.exit(0);
    }

    protected static void doMain(String[] args) throws Exception {
        if (args.length < 1) {
            ThriftServer.printUsageAndExit();
        }
        int port = 9090;
        String portArgKey = "--port=";
        for (String cmd : args) {
            if (cmd.startsWith("--port=")) {
                port = Integer.parseInt(cmd.substring("--port=".length()));
                continue;
            }
            if (cmd.equals("--help") || cmd.equals("-h")) {
                ThriftServer.printUsageAndExit();
            } else {
                if (cmd.equals("start")) continue;
                if (cmd.equals("stop")) {
                    ThriftServer.printUsageAndExit("To shutdown the thrift server run bin/hbase-daemon.sh stop thrift or send a kill signal to the thrift server pid");
                }
            }
            ThriftServer.printUsageAndExit();
        }
        Log LOG = LogFactory.getLog((String)"ThriftServer");
        LOG.info((Object)("starting HBase Thrift server on port " + Integer.toString(port)));
        HBaseHandler handler = new HBaseHandler();
        Hbase.Processor processor = new Hbase.Processor(handler);
        TServerSocket serverTransport = new TServerSocket(port);
        TBinaryProtocol.Factory protFactory = new TBinaryProtocol.Factory(true, true);
        TThreadPoolServer server = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, (TProtocolFactory)protFactory);
        server.serve();
    }

    public static void main(String[] args) throws Exception {
        ThriftServer.doMain(args);
    }

    public static class HBaseHandler
    implements Hbase.Iface {
        protected HBaseConfiguration conf = new HBaseConfiguration();
        protected HBaseAdmin admin = null;
        protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());
        protected int nextScannerId = 0;
        protected HashMap<Integer, ResultScanner> scannerMap = null;

        byte[][] getAllColumns(HTable table) throws IOException {
            HColumnDescriptor[] cds = table.getTableDescriptor().getColumnFamilies();
            byte[][] columns = new byte[cds.length][];
            for (int i = 0; i < cds.length; ++i) {
                columns[i] = cds[i].getNameWithColon();
            }
            return columns;
        }

        protected HTable getTable(byte[] tableName) throws IOError, IOException {
            return new HTable(this.conf, tableName);
        }

        protected synchronized int addScanner(ResultScanner scanner) {
            int id = this.nextScannerId++;
            this.scannerMap.put(id, scanner);
            return id;
        }

        protected synchronized ResultScanner getScanner(int id) {
            return this.scannerMap.get(id);
        }

        protected synchronized ResultScanner removeScanner(int id) {
            return this.scannerMap.remove(id);
        }

        HBaseHandler() throws MasterNotRunningException {
            this.conf = new HBaseConfiguration();
            this.admin = new HBaseAdmin(this.conf);
            this.scannerMap = new HashMap();
        }

        @Override
        public void enableTable(byte[] tableName) throws IOError {
            try {
                this.admin.enableTable(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void disableTable(byte[] tableName) throws IOError {
            try {
                this.admin.disableTable(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOError {
            try {
                return HTable.isTableEnabled(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void compact(byte[] tableNameOrRegionName) throws IOError {
            try {
                this.admin.compact(tableNameOrRegionName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void majorCompact(byte[] tableNameOrRegionName) throws IOError {
            try {
                this.admin.majorCompact(tableNameOrRegionName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<byte[]> getTableNames() throws IOError {
            try {
                HTableDescriptor[] tables = this.admin.listTables();
                ArrayList<byte[]> list = new ArrayList<byte[]>(tables.length);
                for (int i = 0; i < tables.length; ++i) {
                    list.add(tables[i].getName());
                }
                return list;
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRegionInfo> getTableRegions(byte[] tableName) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Map<HRegionInfo, HServerAddress> regionsInfo = table.getRegionsInfo();
                ArrayList<TRegionInfo> regions = new ArrayList<TRegionInfo>();
                for (HRegionInfo regionInfo : regionsInfo.keySet()) {
                    TRegionInfo region = new TRegionInfo();
                    region.startKey = regionInfo.getStartKey();
                    region.endKey = regionInfo.getEndKey();
                    region.id = regionInfo.getRegionId();
                    region.name = regionInfo.getRegionName();
                    region.version = regionInfo.getVersion();
                    regions.add(region);
                }
                return regions;
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> get(byte[] tableName, byte[] row, byte[] column) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            return this.get(tableName, row, famAndQf[0], famAndQf[1]);
        }

        public List<TCell> get(byte[] tableName, byte[] row, byte[] family, byte[] qualifier) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(row);
                if (qualifier == null || qualifier.length == 0) {
                    get2.addFamily(family);
                } else {
                    get2.addColumn(family, qualifier);
                }
                Result result = table.get(get2);
                Cell cell = result.getCellValue(family, qualifier);
                return ThriftUtilities.cellFromHBase(cell);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVer(byte[] tableName, byte[] row, byte[] column, int numVersions) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            return this.getVer(tableName, row, famAndQf[0], famAndQf[1], numVersions);
        }

        public List<TCell> getVer(byte[] tableName, byte[] row, byte[] family, byte[] qualifier, int numVersions) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                ArrayList<Cell> cells = new ArrayList<Cell>();
                if (!result.isEmpty()) {
                    for (KeyValue kv : result.sorted()) {
                        cells.add(new Cell(kv.getValue(), kv.getTimestamp()));
                    }
                }
                return ThriftUtilities.cellFromHBase(cells.toArray(new Cell[0]));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVerTs(byte[] tableName, byte[] row, byte[] column, long timestamp, int numVersions) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            return this.getVerTs(tableName, row, famAndQf[0], famAndQf[1], timestamp, numVersions);
        }

        public List<TCell> getVerTs(byte[] tableName, byte[] row, byte[] family, byte[] qualifier, long timestamp, int numVersions) throws IOError {
            try {
                KeyValue[] kvs;
                HTable table = this.getTable(tableName);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                get2.setTimeRange(Long.MIN_VALUE, timestamp);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                ArrayList<Cell> cells = new ArrayList<Cell>();
                if (!result.isEmpty() && (kvs = result.sorted()) != null) {
                    for (KeyValue kv : kvs) {
                        cells.add(new Cell(kv.getValue(), kv.getTimestamp()));
                    }
                }
                return ThriftUtilities.cellFromHBase(cells.toArray(new Cell[0]));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRowResult> getRow(byte[] tableName, byte[] row) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, Long.MAX_VALUE);
        }

        @Override
        public List<TRowResult> getRowWithColumns(byte[] tableName, byte[] row, List<byte[]> columns) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, columns, Long.MAX_VALUE);
        }

        @Override
        public List<TRowResult> getRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, timestamp);
        }

        @Override
        public List<TRowResult> getRowWithColumnsTs(byte[] tableName, byte[] row, List<byte[]> columns, long timestamp) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                if (columns == null) {
                    Get get2 = new Get(row);
                    get2.setTimeRange(Long.MIN_VALUE, timestamp);
                    Result result = table.get(get2);
                    return ThriftUtilities.rowResultFromHBase(result.getRowResult());
                }
                byte[][] columnArr = (byte[][])columns.toArray((T[])new byte[columns.size()][]);
                Get get3 = new Get(row);
                for (byte[] column : columnArr) {
                    byte[][] famAndQf = KeyValue.parseColumn(column);
                    if (famAndQf[1] == null || famAndQf[1].length == 0) {
                        get3.addFamily(famAndQf[0]);
                        continue;
                    }
                    get3.addColumn(famAndQf[0], famAndQf[1]);
                }
                get3.setTimeRange(Long.MIN_VALUE, timestamp);
                Result result = table.get(get3);
                return ThriftUtilities.rowResultFromHBase(result.getRowResult());
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void deleteAll(byte[] tableName, byte[] row, byte[] column) throws IOError {
            this.deleteAllTs(tableName, row, column, Long.MAX_VALUE);
        }

        @Override
        public void deleteAllTs(byte[] tableName, byte[] row, byte[] column, long timestamp) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Delete delete = new Delete(row);
                byte[][] famAndQf = KeyValue.parseColumn(column);
                if (famAndQf[1].length == 0) {
                    delete.deleteFamily(famAndQf[0], timestamp);
                } else {
                    delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                }
                table.delete(delete);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void deleteAllRow(byte[] tableName, byte[] row) throws IOError {
            this.deleteAllRowTs(tableName, row, Long.MAX_VALUE);
        }

        @Override
        public void deleteAllRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Delete delete = new Delete(row, timestamp, null);
                table.delete(delete);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void createTable(byte[] tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists {
            try {
                if (this.admin.tableExists(tableName)) {
                    throw new AlreadyExists("table name already in use");
                }
                HTableDescriptor desc = new HTableDescriptor(tableName);
                for (ColumnDescriptor col : columnFamilies) {
                    HColumnDescriptor colDesc = ThriftUtilities.colDescFromThrift(col);
                    desc.addFamily(colDesc);
                }
                this.admin.createTable(desc);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        public void deleteTable(byte[] tableName) throws IOError {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("deleteTable: table=" + new String(tableName)));
            }
            try {
                if (!this.admin.tableExists(tableName)) {
                    throw new IOError("table does not exist");
                }
                this.admin.deleteTable(tableName);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void mutateRow(byte[] tableName, byte[] row, List<Mutation> mutations) throws IOError, IllegalArgument {
            this.mutateRowTs(tableName, row, mutations, Long.MAX_VALUE);
        }

        @Override
        public void mutateRowTs(byte[] tableName, byte[] row, List<Mutation> mutations, long timestamp) throws IOError, IllegalArgument {
            HTable table = null;
            try {
                table = this.getTable(tableName);
                Put put = new Put(row);
                put.setTimeStamp(timestamp);
                Delete delete = new Delete(row);
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn(m.column);
                    if (m.isDelete) {
                        if (famAndQf[1].length == 0) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                            continue;
                        }
                        delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        continue;
                    }
                    put.add(famAndQf[0], famAndQf[1], m.value);
                }
                if (!delete.isEmpty()) {
                    table.delete(delete);
                }
                if (!put.isEmpty()) {
                    table.put(put);
                }
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        public void mutateRows(byte[] tableName, List<BatchMutation> rowBatches) throws IOError, IllegalArgument, TException {
            this.mutateRowsTs(tableName, rowBatches, Long.MAX_VALUE);
        }

        @Override
        public void mutateRowsTs(byte[] tableName, List<BatchMutation> rowBatches, long timestamp) throws IOError, IllegalArgument, TException {
            ArrayList<Put> puts = new ArrayList<Put>();
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (BatchMutation batch : rowBatches) {
                byte[] row = batch.row;
                List<Mutation> mutations = batch.mutations;
                Delete delete = new Delete(row);
                Put put = new Put(row);
                put.setTimeStamp(timestamp);
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn(m.column);
                    if (m.isDelete) {
                        if (famAndQf[1].length == 0) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                            continue;
                        }
                        delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        continue;
                    }
                    put.add(famAndQf[0], famAndQf[1], m.value);
                }
                if (!delete.isEmpty()) {
                    deletes.add(delete);
                }
                if (put.isEmpty()) continue;
                puts.add(put);
            }
            HTable table = null;
            try {
                table = this.getTable(tableName);
                if (!puts.isEmpty()) {
                    table.put(puts);
                }
                for (Delete del : deletes) {
                    table.delete(del);
                }
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public long atomicIncrement(byte[] tableName, byte[] row, byte[] column, long amount) throws IOError, IllegalArgument, TException {
            byte[][] famAndQf = KeyValue.parseColumn(column);
            return this.atomicIncrement(tableName, row, famAndQf[0], famAndQf[1], amount);
        }

        public long atomicIncrement(byte[] tableName, byte[] row, byte[] family, byte[] qualifier, long amount) throws IOError, IllegalArgument, TException {
            try {
                HTable table = this.getTable(tableName);
                return table.incrementColumnValue(row, family, qualifier, amount);
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void scannerClose(int id) throws IOError, IllegalArgument {
            this.LOG.debug((Object)("scannerClose: id=" + id));
            ResultScanner scanner = this.getScanner(id);
            if (scanner == null) {
                throw new IllegalArgument("scanner ID is invalid");
            }
            scanner.close();
            this.removeScanner(id);
        }

        @Override
        public List<TRowResult> scannerGetList(int id, int nbRows) throws IllegalArgument, IOError {
            this.LOG.debug((Object)("scannerGetList: id=" + id));
            ResultScanner scanner = this.getScanner(id);
            if (null == scanner) {
                throw new IllegalArgument("scanner ID is invalid");
            }
            Result[] results = null;
            try {
                results = scanner.next(nbRows);
                if (null == results) {
                    return new ArrayList<TRowResult>();
                }
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
            return ThriftUtilities.rowResultFromHBase(results);
        }

        @Override
        public List<TRowResult> scannerGet(int id) throws IllegalArgument, IOError {
            return this.scannerGetList(id, 1);
        }

        @Override
        public int scannerOpen(byte[] tableName, byte[] startRow, List<byte[]> columns) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                byte[][] columnsArray = null;
                columnsArray = columns == null || columns.size() == 0 ? this.getAllColumns(table) : (byte[][])columns.toArray((T[])new byte[0][]);
                Scan scan = new Scan(startRow);
                scan.addColumns(columnsArray);
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithStop(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                byte[][] columnsArray = null;
                columnsArray = columns == null || columns.size() == 0 ? this.getAllColumns(table) : (byte[][])columns.toArray((T[])new byte[0][]);
                Scan scan = new Scan(startRow, stopRow);
                scan.addColumns(columnsArray);
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithPrefix(byte[] tableName, byte[] startAndPrefix, List<byte[]> columns) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                byte[][] columnsArray = null;
                columnsArray = (byte[][])columns.toArray((T[])new byte[0][]);
                Scan scan = new Scan(startAndPrefix);
                scan.addColumns(columnsArray);
                WhileMatchFilter f = new WhileMatchFilter(new PrefixFilter(startAndPrefix));
                scan.setFilter(f);
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenTs(byte[] tableName, byte[] startRow, List<byte[]> columns, long timestamp) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                byte[][] columnsArray = null;
                columnsArray = columns == null || columns.size() == 0 ? this.getAllColumns(table) : (byte[][])columns.toArray((T[])new byte[0][]);
                Scan scan = new Scan(startRow);
                scan.addColumns(columnsArray);
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithStopTs(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns, long timestamp) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                byte[][] columnsArray = null;
                columnsArray = columns == null || columns.size() == 0 ? this.getAllColumns(table) : (byte[][])columns.toArray((T[])new byte[0][]);
                Scan scan = new Scan(startRow, stopRow);
                scan.addColumns(columnsArray);
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                return this.addScanner(table.getScanner(scan));
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public Map<byte[], ColumnDescriptor> getColumnDescriptors(byte[] tableName) throws IOError, TException {
            try {
                TreeMap<byte[], ColumnDescriptor> columns = new TreeMap<byte[], ColumnDescriptor>(Bytes.BYTES_COMPARATOR);
                HTable table = this.getTable(tableName);
                HTableDescriptor desc = table.getTableDescriptor();
                for (HColumnDescriptor e : desc.getFamilies()) {
                    ColumnDescriptor col = ThriftUtilities.colDescFromHbase(e);
                    columns.put(col.name, col);
                }
                return columns;
            }
            catch (IOException e) {
                throw new IOError(e.getMessage());
            }
        }
    }
}

