/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.JobCloseFeedBack;
import org.apache.hadoop.hive.ql.exec.SkewJoinHandler;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;

public class JoinOperator
extends CommonJoinOperator<JoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient SkewJoinHandler skewJoinKeyContext = null;
    private final transient LongWritable skewjoin_followup_jobs = new LongWritable(0L);

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.initializeChildren(hconf);
        if (this.handleSkewJoin) {
            this.skewJoinKeyContext = new SkewJoinHandler(this);
            this.skewJoinKeyContext.initiliaze(hconf);
            this.skewJoinKeyContext.setSkewJoinJobCounter(this.skewjoin_followup_jobs);
        }
        this.statsMap.put(SkewkeyTableCounter.SKEWJOINFOLLOWUPJOBS, this.skewjoin_followup_jobs);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            this.alias = (byte)tag;
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            ArrayList<Object> nr = JoinOperator.computeValues(row, (List)this.joinValues.get(this.alias), (List)this.joinValuesObjectInspectors.get(this.alias));
            if (this.handleSkewJoin) {
                this.skewJoinKeyContext.handleSkew(tag);
            }
            int sz = ((RowContainer)this.storage.get(this.alias)).size();
            if (!(this.alias != this.numAliases - 1 || this.handleSkewJoin && this.skewJoinKeyContext.currBigKeyTag >= 0)) {
                if (sz == this.joinEmitInterval) {
                    this.checkAndGenObject();
                    ((RowContainer)this.storage.get(this.alias)).clear();
                }
            } else if (sz == this.nextSz) {
                StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[tag];
                StructField sf = soi.getStructFieldRef(Utilities.ReduceField.KEY.toString());
                Object keyObject = soi.getStructFieldData(row, sf);
                LOG.warn((Object)("table " + this.alias + " has " + sz + " rows for join key " + keyObject));
                this.nextSz = this.getNextSize(this.nextSz);
            }
            ((RowContainer)this.storage.get(this.alias)).add(nr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.JOIN;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.handleSkewJoin) {
            this.skewJoinKeyContext.close(abort);
        }
        super.closeOp(abort);
    }

    @Override
    public void jobClose(Configuration hconf, boolean success, JobCloseFeedBack feedBack) throws HiveException {
        int numAliases = ((JoinDesc)this.conf).getExprs().size();
        if (((JoinDesc)this.conf).getHandleSkewJoin()) {
            try {
                int j;
                String specPath;
                int i;
                for (i = 0; i < numAliases; ++i) {
                    specPath = ((JoinDesc)this.conf).getBigKeysDirMap().get((byte)i);
                    this.mvFileToFinalPath(specPath, hconf, success, LOG);
                    for (j = 0; j < numAliases; ++j) {
                        if (j == i) continue;
                        specPath = ((JoinDesc)this.getConf()).getSmallKeysDirMap().get((byte)i).get((byte)j);
                        this.mvFileToFinalPath(specPath, hconf, success, LOG);
                    }
                }
                if (success) {
                    for (i = 0; i < numAliases; ++i) {
                        specPath = ((JoinDesc)this.conf).getBigKeysDirMap().get((byte)i);
                        this.moveUpFiles(specPath, hconf, LOG);
                        for (j = 0; j < numAliases; ++j) {
                            if (j == i) continue;
                            specPath = ((JoinDesc)this.getConf()).getSmallKeysDirMap().get((byte)i).get((byte)j);
                            this.moveUpFiles(specPath, hconf, LOG);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }
        super.jobClose(hconf, success, feedBack);
    }

    private void moveUpFiles(String specPath, Configuration hconf, Log log) throws IOException, HiveException {
        FileStatus[] taskOutputDirs;
        Path finalPath;
        FileSystem fs = new Path(specPath).getFileSystem(hconf);
        if (fs.exists(finalPath = new Path(specPath)) && (taskOutputDirs = fs.listStatus(finalPath)) != null) {
            for (FileStatus dir : taskOutputDirs) {
                Utilities.renameOrMoveFiles(fs, dir.getPath(), finalPath);
                fs.delete(dir.getPath(), true);
            }
        }
    }

    private void mvFileToFinalPath(String specPath, Configuration hconf, boolean success, Log log) throws IOException, HiveException {
        FileSystem fs = new Path(specPath).getFileSystem(hconf);
        Path tmpPath = Utilities.toTempPath(specPath);
        Path intermediatePath = new Path(tmpPath.getParent(), tmpPath.getName() + ".intermediate");
        Path finalPath = new Path(specPath);
        Object emptyBuckets = null;
        if (success) {
            if (fs.exists(tmpPath)) {
                log.info((Object)("Moving tmp dir: " + tmpPath + " to: " + intermediatePath));
                Utilities.rename(fs, tmpPath, intermediatePath);
                Utilities.removeTempOrDuplicateFiles(fs, intermediatePath);
                log.info((Object)("Moving tmp dir: " + intermediatePath + " to: " + finalPath));
                Utilities.renameOrMoveFiles(fs, intermediatePath, finalPath);
            }
        } else {
            fs.delete(tmpPath, true);
        }
    }

    @Override
    public void endGroup() throws HiveException {
        if (this.handleSkewJoin && this.skewJoinKeyContext.currBigKeyTag >= 0) {
            try {
                this.skewJoinKeyContext.endGroup();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new HiveException(e);
            }
            return;
        }
        this.checkAndGenObject();
    }

    public static enum SkewkeyTableCounter {
        SKEWJOINFOLLOWUPJOBS;

    }
}

