/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.TaskHandle;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;

public abstract class Task<T extends Serializable>
implements Serializable,
Node {
    private static final long serialVersionUID = 1L;
    protected transient boolean started = false;
    protected transient boolean initialized = false;
    protected transient boolean isdone = false;
    protected transient boolean queued = false;
    protected transient HiveConf conf;
    protected transient Hive db;
    protected transient Log LOG = LogFactory.getLog((String)this.getClass().getName());
    protected transient SessionState.LogHelper console;
    protected transient QueryPlan queryPlan;
    protected transient TaskHandle taskHandle;
    protected transient HashMap<String, Long> taskCounters = new HashMap();
    protected transient DriverContext driverContext;
    protected List<Task<? extends Serializable>> childTasks;
    protected List<Task<? extends Serializable>> parentTasks;
    protected String id;
    protected T work;

    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        this.queryPlan = queryPlan;
        this.isdone = false;
        this.started = false;
        this.setInitialized();
        this.conf = conf;
        try {
            this.db = Hive.get(conf);
        }
        catch (HiveException e) {
            this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        this.driverContext = driverContext;
        this.console = new SessionState.LogHelper(this.LOG);
    }

    public int executeTask() {
        try {
            SessionState ss = SessionState.get();
            this.setStarted();
            if (ss != null) {
                ss.getHiveHistory().logPlanProgress(this.queryPlan);
            }
            int retval = this.execute(this.driverContext);
            this.setDone();
            if (ss != null) {
                ss.getHiveHistory().logPlanProgress(this.queryPlan);
            }
            return retval;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected abstract int execute(DriverContext var1);

    public void progress(TaskHandle taskHandle) throws IOException {
    }

    public boolean fetch(ArrayList<String> res) throws IOException {
        assert (false);
        return false;
    }

    public void setChildTasks(List<Task<? extends Serializable>> childTasks) {
        this.childTasks = childTasks;
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.getChildTasks();
    }

    public List<Task<? extends Serializable>> getChildTasks() {
        return this.childTasks;
    }

    public void setParentTasks(List<Task<? extends Serializable>> parentTasks) {
        this.parentTasks = parentTasks;
    }

    public List<Task<? extends Serializable>> getParentTasks() {
        return this.parentTasks;
    }

    public List<Task<? extends Serializable>> getDependentTasks() {
        return this.getChildTasks();
    }

    public boolean addDependentTask(Task<? extends Serializable> dependent) {
        boolean ret = false;
        if (this.getChildTasks() == null) {
            this.setChildTasks(new ArrayList<Task<? extends Serializable>>());
        }
        if (!this.getChildTasks().contains(dependent)) {
            ret = true;
            this.getChildTasks().add(dependent);
            if (dependent.getParentTasks() == null) {
                dependent.setParentTasks(new ArrayList<Task<? extends Serializable>>());
            }
            if (!dependent.getParentTasks().contains(this)) {
                dependent.getParentTasks().add(this);
            }
        }
        return ret;
    }

    public void removeDependentTask(Task<? extends Serializable> dependent) {
        if (this.getChildTasks() != null && this.getChildTasks().contains(dependent)) {
            this.getChildTasks().remove(dependent);
            if (dependent.getParentTasks() != null && dependent.getParentTasks().contains(this)) {
                dependent.getParentTasks().remove(this);
            }
        }
    }

    public void setStarted() {
        this.started = true;
    }

    public boolean started() {
        return this.started;
    }

    public boolean done() {
        return this.isdone;
    }

    public void setDone() {
        this.isdone = true;
    }

    public void setQueued() {
        this.queued = true;
    }

    public boolean getQueued() {
        return this.queued;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public boolean isRunnable() {
        boolean isrunnable = true;
        if (this.parentTasks != null) {
            for (Task<? extends Serializable> parent : this.parentTasks) {
                if (parent.done()) continue;
                isrunnable = false;
                break;
            }
        }
        return isrunnable;
    }

    public void setWork(T work) {
        this.work = work;
    }

    public T getWork() {
        return this.work;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isMapRedTask() {
        return false;
    }

    public boolean hasReduce() {
        return false;
    }

    public void updateCounters(TaskHandle th) throws IOException {
    }

    public HashMap<String, Long> getCounters() {
        return this.taskCounters;
    }

    public abstract StageType getType();
}

