/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hive.ql.exec.JobTrackerURLResolver;
import org.apache.hadoop.mapred.JobConf;

public final class Throttle {
    private static final int DEFAULT_MEMORY_GC_PERCENT = 100;
    private static final int DEFAULT_RETRY_PERIOD = 60;

    static void checkJobTracker(JobConf conf, Log LOG) {
        try {
            byte[] buffer = new byte[1024];
            int threshold = conf.getInt("mapred.throttle.threshold.percent", 100);
            int retry = conf.getInt("mapred.throttle.retry.period", 60);
            if (threshold == 100) {
                return;
            }
            String tracker = JobTrackerURLResolver.getURL(conf) + "/gc.jsp?threshold=" + threshold;
            while (true) {
                URL url = new URL(tracker);
                LOG.debug((Object)("Throttle: URL " + tracker));
                InputStream in = url.openStream();
                in.read(buffer);
                in.close();
                String fetchString = new String(buffer);
                Pattern dowait = Pattern.compile("<dogc>", 42);
                String[] results = dowait.split(fetchString);
                if (results.length != 2) {
                    throw new IOException("Throttle: Unable to parse response of URL " + url + ". Get retuned " + fetchString);
                }
                dowait = Pattern.compile("</dogc>", 42);
                results = dowait.split(results[1]);
                if (results.length < 1) {
                    throw new IOException("Throttle: Unable to parse response of URL " + url + ". Get retuned " + fetchString);
                }
                if (results[0].trim().compareToIgnoreCase("false") == 0) {
                    return;
                }
                LOG.warn((Object)("Job is being throttled because of resource crunch on the JobTracker. Will retry in " + retry + " seconds.."));
                Thread.sleep((long)retry * 1000L);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Job is not being throttled. " + e));
            return;
        }
    }

    private Throttle() {
    }
}

