/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinObjectKey
implements Externalizable {
    protected transient int metadataTag;
    protected transient ArrayList<Object> obj;

    public MapJoinObjectKey() {
    }

    public MapJoinObjectKey(int metadataTag, ArrayList<Object> obj) {
        this.metadataTag = metadataTag;
        this.obj = obj;
    }

    public boolean equals(Object o) {
        MapJoinObjectKey mObj;
        if (o instanceof MapJoinObjectKey && (mObj = (MapJoinObjectKey)o).getMetadataTag() == this.metadataTag) {
            if (this.obj == null && mObj.getObj() == null) {
                return true;
            }
            if (this.obj != null && mObj.getObj() != null && mObj.getObj().equals(this.obj)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.obj == null ? this.metadataTag : this.obj.hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.metadataTag = in.readInt();
            MapJoinOperator.MapJoinObjectCtx ctx = MapJoinOperator.getMapMetadata().get(this.metadataTag);
            Writable val = ctx.getSerDe().getSerializedClass().newInstance();
            val.readFields((DataInput)in);
            this.obj = (ArrayList)ObjectInspectorUtils.copyToStandardObject(ctx.getSerDe().deserialize(val), ctx.getSerDe().getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeInt(this.metadataTag);
            MapJoinOperator.MapJoinObjectCtx ctx = MapJoinOperator.getMapMetadata().get(this.metadataTag);
            Writable outVal = ctx.getSerDe().serialize(this.obj, ctx.getStandardOI());
            outVal.write((DataOutput)out);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    public int getMetadataTag() {
        return this.metadataTag;
    }

    public void setMetadataTag(int metadataTag) {
        this.metadataTag = metadataTag;
    }

    public ArrayList<Object> getObj() {
        return this.obj;
    }

    public void setObj(ArrayList<Object> obj) {
        this.obj = obj;
    }
}

