/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.CodecPool;
import org.apache.hadoop.hive.ql.io.NonSyncDataInputBuffer;
import org.apache.hadoop.hive.ql.io.NonSyncDataOutputBuffer;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.columnar.LazyDecompressionCallback;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class RCFile {
    private static final Log LOG = LogFactory.getLog(RCFile.class);
    public static final String RECORD_INTERVAL_CONF_STR = "hive.io.rcfile.record.interval";
    public static final String COLUMN_NUMBER_METADATA_STR = "hive.io.rcfile.column.number";
    public static final String COLUMN_NUMBER_CONF_STR = "hive.io.rcfile.column.number.conf";
    private static final byte VERSION_WITH_METADATA = 6;
    private static final byte[] VERSION = new byte[]{83, 69, 81, 6};
    private static final int SYNC_ESCAPE = -1;
    private static final int SYNC_HASH_SIZE = 16;
    private static final int SYNC_SIZE = 20;
    public static final int SYNC_INTERVAL = 2000;

    public static class Reader {
        private final Path file;
        private final FSDataInputStream in;
        private byte version;
        private CompressionCodec codec = null;
        private SequenceFile.Metadata metadata = null;
        private final byte[] sync = new byte[16];
        private final byte[] syncCheck = new byte[16];
        private boolean syncSeen;
        private long lastSeenSyncPos = 0L;
        private long headerEnd;
        private final long end;
        private int currentKeyLength;
        private int currentRecordLength;
        private final Configuration conf;
        private final ValueBuffer currentValue;
        private boolean[] skippedColIDs = null;
        private int readRowsIndexInBuffer = 0;
        private int recordsNumInValBuffer = 0;
        private int columnNumber = 0;
        private int loadColumnNum;
        private int passedRowsNum = 0;
        private int[] columnRowReadIndex = null;
        private final NonSyncDataInputBuffer[] colValLenBufferReadIn;
        private final int[] columnRunLength;
        private final int[] columnPrvLength;
        private boolean decompress = false;
        private Decompressor keyDecompressor;
        NonSyncDataOutputBuffer keyDecompressedData = new NonSyncDataOutputBuffer();
        int[] prjColIDs = null;
        private int compressedKeyLen = 0;
        NonSyncDataInputBuffer keyDataIn = new NonSyncDataInputBuffer();
        NonSyncDataInputBuffer keyDecompressBuffer = new NonSyncDataInputBuffer();
        NonSyncDataOutputBuffer keyTempBuffer = new NonSyncDataOutputBuffer();
        KeyBuffer currentKey = null;
        boolean keyInit = false;
        private boolean rowFetched = false;
        private final NonSyncDataInputBuffer fetchColumnTempBuf = new NonSyncDataInputBuffer();

        public Reader(FileSystem fs, Path file, Configuration conf) throws IOException {
            this(fs, file, conf.getInt("io.file.buffer.size", 4096), conf, 0L, fs.getFileStatus(file).getLen());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader(FileSystem fs, Path file, int bufferSize, Configuration conf, long start, long length) throws IOException {
            int i;
            conf.setInt("io.file.buffer.size", bufferSize);
            this.file = file;
            this.in = this.openFile(fs, file, bufferSize, length);
            this.conf = conf;
            this.end = start + length;
            boolean succeed = false;
            try {
                if (start > 0L) {
                    this.seek(0L);
                    this.init();
                    this.seek(start);
                } else {
                    this.init();
                }
                succeed = true;
            }
            finally {
                block21: {
                    if (!succeed && this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException e) {
                            if (LOG == null || !LOG.isDebugEnabled()) break block21;
                            LOG.debug((Object)("Exception in closing " + this.in), (Throwable)e);
                        }
                    }
                }
            }
            this.columnNumber = Integer.parseInt(this.metadata.get(new Text(RCFile.COLUMN_NUMBER_METADATA_STR)).toString());
            ArrayList<Integer> notSkipIDs = ColumnProjectionUtils.getReadColumnIDs(conf);
            this.skippedColIDs = new boolean[this.columnNumber];
            if (notSkipIDs.size() > 0) {
                for (int i2 = 0; i2 < this.skippedColIDs.length; ++i2) {
                    this.skippedColIDs[i2] = true;
                }
                for (int read : notSkipIDs) {
                    if (read >= this.columnNumber) continue;
                    this.skippedColIDs[read] = false;
                }
            } else {
                for (int i3 = 0; i3 < this.skippedColIDs.length; ++i3) {
                    this.skippedColIDs[i3] = false;
                }
            }
            this.loadColumnNum = this.columnNumber;
            if (this.skippedColIDs != null && this.skippedColIDs.length > 0) {
                for (boolean skippedColID : this.skippedColIDs) {
                    if (!skippedColID) continue;
                    --this.loadColumnNum;
                }
            }
            this.prjColIDs = new int[this.loadColumnNum];
            int j = 0;
            for (i = 0; i < this.columnNumber; ++i) {
                if (this.skippedColIDs[i]) continue;
                this.prjColIDs[j++] = i;
            }
            this.colValLenBufferReadIn = new NonSyncDataInputBuffer[this.columnNumber];
            this.columnRunLength = new int[this.columnNumber];
            this.columnPrvLength = new int[this.columnNumber];
            this.columnRowReadIndex = new int[this.columnNumber];
            for (i = 0; i < this.columnNumber; ++i) {
                this.columnRowReadIndex[i] = 0;
                if (!this.skippedColIDs[i]) {
                    this.colValLenBufferReadIn[i] = new NonSyncDataInputBuffer();
                }
                this.columnRunLength[i] = 0;
                this.columnPrvLength[i] = -1;
            }
            this.currentKey = this.createKeyBuffer();
            this.currentValue = new ValueBuffer(null, this.columnNumber, this.skippedColIDs, this.codec);
        }

        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return fs.open(file, bufferSize);
        }

        private void init() throws IOException {
            byte[] versionBlock = new byte[VERSION.length];
            this.in.readFully(versionBlock);
            if (versionBlock[0] != VERSION[0] || versionBlock[1] != VERSION[1] || versionBlock[2] != VERSION[2]) {
                throw new IOException(this.file + " not a RCFile");
            }
            this.version = versionBlock[3];
            if (this.version > VERSION[3]) {
                throw new VersionMismatchException(VERSION[3], this.version);
            }
            try {
                Class keyCls = this.conf.getClassByName(Text.readString((DataInput)this.in));
                Class valCls = this.conf.getClassByName(Text.readString((DataInput)this.in));
                if (!keyCls.equals(KeyBuffer.class) || !valCls.equals(ValueBuffer.class)) {
                    throw new IOException(this.file + " not a RCFile");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(this.file + " not a RCFile", e);
            }
            this.decompress = this.version > 2 ? this.in.readBoolean() : false;
            boolean blkCompressed = this.in.readBoolean();
            if (blkCompressed) {
                throw new IOException(this.file + " not a RCFile.");
            }
            if (this.decompress) {
                String codecClassname = Text.readString((DataInput)this.in);
                try {
                    Class<CompressionCodec> codecClass = this.conf.getClassByName(codecClassname).asSubclass(CompressionCodec.class);
                    this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Unknown codec: " + codecClassname, cnfe);
                }
                this.keyDecompressor = CodecPool.getDecompressor(this.codec);
            }
            this.metadata = new SequenceFile.Metadata();
            if (this.version >= 6) {
                this.metadata.readFields((DataInput)this.in);
            }
            if (this.version > 1) {
                this.in.readFully(this.sync);
                this.headerEnd = this.in.getPos();
            }
        }

        public synchronized long getPosition() throws IOException {
            return this.in.getPos();
        }

        public synchronized void seek(long position) throws IOException {
            this.in.seek(position);
        }

        public synchronized void sync(long position) throws IOException {
            if (position + 20L >= this.end) {
                this.seek(this.end);
                return;
            }
            if (position < this.headerEnd) {
                this.in.seek(this.headerEnd);
                this.syncSeen = true;
                return;
            }
            try {
                this.seek(position + 4L);
                this.in.readFully(this.syncCheck);
                int syncLen = this.sync.length;
                int i = 0;
                while (this.in.getPos() < this.end) {
                    int j;
                    for (j = 0; j < syncLen && this.sync[j] == this.syncCheck[(i + j) % syncLen]; ++j) {
                    }
                    if (j == syncLen) {
                        this.in.seek(this.in.getPos() - 20L);
                        return;
                    }
                    this.syncCheck[i % syncLen] = this.in.readByte();
                    ++i;
                }
            }
            catch (ChecksumException e) {
                this.handleChecksumException(e);
            }
        }

        private void handleChecksumException(ChecksumException e) throws IOException {
            if (!this.conf.getBoolean("io.skip.checksum.errors", false)) {
                throw e;
            }
            LOG.warn((Object)("Bad checksum at " + this.getPosition() + ". Skipping entries."));
            this.sync(this.getPosition() + (long)this.conf.getInt("io.bytes.per.checksum", 512));
        }

        private KeyBuffer createKeyBuffer() {
            return new KeyBuffer(this.columnNumber);
        }

        private ValueBuffer createValueBuffer(KeyBuffer key) throws IOException {
            return new ValueBuffer(key, this.skippedColIDs);
        }

        private synchronized int readRecordLength() throws IOException {
            if (this.in.getPos() >= this.end) {
                return -1;
            }
            int length = this.in.readInt();
            if (this.version > 1 && this.sync != null && length == -1) {
                this.lastSeenSyncPos = this.in.getPos() - 4L;
                this.in.readFully(this.syncCheck);
                if (!Arrays.equals(this.sync, this.syncCheck)) {
                    throw new IOException("File is corrupt!");
                }
                this.syncSeen = true;
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                length = this.in.readInt();
            } else {
                this.syncSeen = false;
            }
            return length;
        }

        private void seekToNextKeyBuffer() throws IOException {
            if (!this.keyInit) {
                return;
            }
            if (!this.currentValue.inited) {
                this.in.skip((long)(this.currentRecordLength - this.currentKeyLength));
            }
        }

        protected int nextKeyBuffer() throws IOException {
            this.seekToNextKeyBuffer();
            this.currentRecordLength = this.readRecordLength();
            if (this.currentRecordLength == -1) {
                this.keyInit = false;
                return -1;
            }
            this.currentKeyLength = this.in.readInt();
            this.compressedKeyLen = this.in.readInt();
            if (this.decompress) {
                this.keyTempBuffer.reset();
                this.keyTempBuffer.write((DataInput)this.in, this.compressedKeyLen);
                this.keyDecompressBuffer.reset(this.keyTempBuffer.getData(), this.compressedKeyLen);
                CompressionInputStream deflatFilter = this.codec.createInputStream((InputStream)this.keyDecompressBuffer, this.keyDecompressor);
                DataInputStream compressedIn = new DataInputStream((InputStream)deflatFilter);
                deflatFilter.resetState();
                this.keyDecompressedData.reset();
                this.keyDecompressedData.write(compressedIn, this.currentKeyLength);
                this.keyDataIn.reset(this.keyDecompressedData.getData(), this.currentKeyLength);
                this.currentKey.readFields(this.keyDataIn);
            } else {
                this.currentKey.readFields((DataInput)this.in);
            }
            this.keyInit = true;
            this.currentValue.inited = false;
            this.readRowsIndexInBuffer = 0;
            this.recordsNumInValBuffer = this.currentKey.numberRows;
            int[] arr$ = this.prjColIDs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int prjColID;
                int i = prjColID = arr$[i$];
                this.colValLenBufferReadIn[i].reset(this.currentKey.allCellValLenBuffer[i].getData(), this.currentKey.allCellValLenBuffer[i].getLength());
                this.columnRowReadIndex[i] = 0;
                this.columnRunLength[i] = 0;
                this.columnPrvLength[i] = -1;
            }
            return this.currentKeyLength;
        }

        protected void currentValueBuffer() throws IOException {
            if (!this.keyInit) {
                this.nextKeyBuffer();
            }
            this.currentValue.keyBuffer = this.currentKey;
            this.currentValue.clearColumnBuffer();
            this.currentValue.readFields((DataInput)this.in);
            this.currentValue.inited = true;
        }

        public BytesRefArrayWritable getColumn(int columnID, BytesRefArrayWritable rest) throws IOException {
            if (this.skippedColIDs[columnID]) {
                return null;
            }
            if (rest == null) {
                rest = new BytesRefArrayWritable();
            }
            rest.resetValid(this.recordsNumInValBuffer);
            if (!this.currentValue.inited) {
                this.currentValueBuffer();
            }
            int columnNextRowStart = 0;
            this.fetchColumnTempBuf.reset(this.currentKey.allCellValLenBuffer[columnID].getData(), this.currentKey.allCellValLenBuffer[columnID].getLength());
            for (int i = 0; i < this.recordsNumInValBuffer; ++i) {
                int length = this.getColumnNextValueLength(columnID);
                BytesRefWritable currentCell = rest.get(i);
                if (this.currentValue.decompressedFlag[columnID]) {
                    currentCell.set(this.currentValue.loadedColumnsValueBuffer[columnID].getData(), columnNextRowStart, length);
                } else {
                    currentCell.set(this.currentValue.lazyDecompressCallbackObjs[columnID], columnNextRowStart, length);
                }
                columnNextRowStart += length;
            }
            return rest;
        }

        public synchronized boolean nextColumnsBatch() throws IOException {
            this.passedRowsNum += this.recordsNumInValBuffer - this.readRowsIndexInBuffer;
            return this.nextKeyBuffer() > 0;
        }

        public synchronized boolean next(LongWritable readRows) throws IOException {
            if (this.hasRecordsInBuffer()) {
                readRows.set((long)this.passedRowsNum);
                ++this.readRowsIndexInBuffer;
                ++this.passedRowsNum;
                this.rowFetched = false;
                return true;
            }
            this.keyInit = false;
            int ret = -1;
            try {
                ret = this.nextKeyBuffer();
            }
            catch (EOFException eof) {
                eof.printStackTrace();
            }
            if (ret > 0) {
                return this.next(readRows);
            }
            return false;
        }

        public boolean hasRecordsInBuffer() {
            return this.readRowsIndexInBuffer < this.recordsNumInValBuffer;
        }

        public synchronized void getCurrentRow(BytesRefArrayWritable ret) throws IOException {
            if (!this.keyInit || this.rowFetched) {
                return;
            }
            if (!this.currentValue.inited) {
                this.currentValueBuffer();
                ret.resetValid(this.columnNumber);
            }
            for (int j = 0; j < this.prjColIDs.length; ++j) {
                int i = this.prjColIDs[j];
                BytesRefWritable ref = ret.unCheckedGet(i);
                int columnCurrentRowStart = this.columnRowReadIndex[i];
                int length = this.getColumnNextValueLength(i);
                this.columnRowReadIndex[i] = columnCurrentRowStart + length;
                if (this.currentValue.decompressedFlag[j]) {
                    ref.set(this.currentValue.loadedColumnsValueBuffer[j].getData(), columnCurrentRowStart, length);
                    continue;
                }
                ref.set(this.currentValue.lazyDecompressCallbackObjs[j], columnCurrentRowStart, length);
            }
            this.rowFetched = true;
        }

        private int getColumnNextValueLength(int i) throws IOException {
            if (this.columnRunLength[i] > 0) {
                int n = i;
                this.columnRunLength[n] = this.columnRunLength[n] - 1;
                return this.columnPrvLength[i];
            }
            int length = (int)WritableUtils.readVLong((DataInput)this.colValLenBufferReadIn[i]);
            if (length < 0) {
                this.columnRunLength[i] = ~length;
                int n = i;
                this.columnRunLength[n] = this.columnRunLength[n] - 1;
                length = this.columnPrvLength[i];
            } else {
                this.columnPrvLength[i] = length;
                this.columnRunLength[i] = 0;
            }
            return length;
        }

        public boolean syncSeen() {
            return this.syncSeen;
        }

        public long lastSeenSyncPos() {
            return this.lastSeenSyncPos;
        }

        public String toString() {
            return this.file.toString();
        }

        public void close() {
            IOUtils.closeStream((Closeable)this.in);
            this.currentValue.close();
            if (this.decompress) {
                IOUtils.closeStream((Closeable)this.keyDecompressedData);
                CodecPool.returnDecompressor(this.keyDecompressor);
            }
        }
    }

    public static class Writer {
        Configuration conf;
        FSDataOutputStream out;
        CompressionCodec codec = null;
        SequenceFile.Metadata metadata = null;
        Compressor compressor = null;
        long lastSyncPos;
        byte[] sync;
        private int RECORD_INTERVAL;
        private int columnsBufferSize;
        public static String COLUMNS_BUFFER_SIZE_CONF_STR = "hive.io.rcfile.record.buffer.size";
        private int bufferedRecords;
        NonSyncDataOutputBuffer[] compressionBuffer;
        CompressionOutputStream[] deflateFilter;
        DataOutputStream[] deflateOut;
        private final ColumnBuffer[] columnBuffers;
        NonSyncDataOutputBuffer keyCompressionBuffer;
        CompressionOutputStream keyDeflateFilter;
        DataOutputStream keyDeflateOut;
        Compressor keyCompressor;
        private int columnNumber;
        private final int[] columnValuePlainLength;
        KeyBuffer key;
        ValueBuffer value;
        private int columnBufferSize;

        public long getLength() throws IOException {
            return this.out.getPos();
        }

        public Writer(FileSystem fs, Configuration conf, Path name) throws IOException {
            this(fs, conf, name, null, new SequenceFile.Metadata(), null);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Progressable progress, CompressionCodec codec) throws IOException {
            this(fs, conf, name, null, new SequenceFile.Metadata(), codec);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Progressable progress, SequenceFile.Metadata metadata, CompressionCodec codec) throws IOException {
            this(fs, conf, name, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), progress, metadata, codec);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, int bufferSize, short replication, long blockSize, Progressable progress, SequenceFile.Metadata metadata, CompressionCodec codec) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = System.currentTimeMillis();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.RECORD_INTERVAL = Integer.MAX_VALUE;
            this.columnsBufferSize = 0x400000;
            this.bufferedRecords = 0;
            this.deflateFilter = null;
            this.deflateOut = null;
            this.columnNumber = 0;
            this.key = null;
            this.value = null;
            this.columnBufferSize = 0;
            this.RECORD_INTERVAL = conf.getInt(RCFile.RECORD_INTERVAL_CONF_STR, this.RECORD_INTERVAL);
            this.columnNumber = conf.getInt(RCFile.COLUMN_NUMBER_CONF_STR, 0);
            if (metadata == null) {
                metadata = new SequenceFile.Metadata();
            }
            metadata.set(new Text(RCFile.COLUMN_NUMBER_METADATA_STR), new Text("" + this.columnNumber));
            this.columnsBufferSize = conf.getInt(COLUMNS_BUFFER_SIZE_CONF_STR, 0x400000);
            this.columnValuePlainLength = new int[this.columnNumber];
            this.columnBuffers = new ColumnBuffer[this.columnNumber];
            for (int i = 0; i < this.columnNumber; ++i) {
                this.columnBuffers[i] = new ColumnBuffer();
            }
            this.init(name, conf, fs.create(name, true, bufferSize, replication, blockSize, progress), codec, metadata);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
            this.key = new KeyBuffer(this.columnNumber);
            this.value = new ValueBuffer(this.key);
        }

        void initializeFileHeader() throws IOException {
            this.out.write(VERSION);
        }

        void finalizeFileHeader() throws IOException {
            this.out.write(this.sync);
            this.out.flush();
        }

        boolean isCompressed() {
            return this.codec != null;
        }

        void writeFileHeader() throws IOException {
            Text.writeString((DataOutput)this.out, (String)KeyBuffer.class.getName());
            Text.writeString((DataOutput)this.out, (String)ValueBuffer.class.getName());
            this.out.writeBoolean(this.isCompressed());
            this.out.writeBoolean(false);
            if (this.isCompressed()) {
                Text.writeString((DataOutput)this.out, (String)this.codec.getClass().getName());
            }
            this.metadata.write((DataOutput)this.out);
        }

        void init(Path name, Configuration conf, FSDataOutputStream out, CompressionCodec codec, SequenceFile.Metadata metadata) throws IOException {
            this.conf = conf;
            this.out = out;
            this.codec = codec;
            this.metadata = metadata;
            if (this.codec != null) {
                ReflectionUtils.setConf((Object)codec, (Configuration)this.conf);
                this.compressor = CodecPool.getCompressor(codec);
                this.compressionBuffer = new NonSyncDataOutputBuffer[this.columnNumber];
                this.deflateFilter = new CompressionOutputStream[this.columnNumber];
                this.deflateOut = new DataOutputStream[this.columnNumber];
                for (int i = 0; i < this.columnNumber; ++i) {
                    this.compressionBuffer[i] = new NonSyncDataOutputBuffer();
                    this.deflateFilter[i] = codec.createOutputStream((OutputStream)this.compressionBuffer[i], this.compressor);
                    this.deflateOut[i] = new DataOutputStream(new BufferedOutputStream((OutputStream)this.deflateFilter[i]));
                }
                this.keyCompressor = CodecPool.getCompressor(codec);
                this.keyCompressionBuffer = new NonSyncDataOutputBuffer();
                this.keyDeflateFilter = codec.createOutputStream((OutputStream)this.keyCompressionBuffer, this.keyCompressor);
                this.keyDeflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)this.keyDeflateFilter));
            }
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        public void sync() throws IOException {
            if (this.sync != null && this.lastSyncPos != this.out.getPos()) {
                this.out.writeInt(-1);
                this.out.write(this.sync);
                this.lastSyncPos = this.out.getPos();
            }
        }

        Configuration getConf() {
            return this.conf;
        }

        private void checkAndWriteSync() throws IOException {
            if (this.sync != null && this.out.getPos() >= this.lastSyncPos + 2000L) {
                this.sync();
            }
        }

        public void append(Writable val) throws IOException {
            int i;
            if (!(val instanceof BytesRefArrayWritable)) {
                throw new UnsupportedOperationException("Currently the writer can only accept BytesRefArrayWritable");
            }
            BytesRefArrayWritable columns = (BytesRefArrayWritable)val;
            int size = columns.size();
            for (i = 0; i < size; ++i) {
                BytesRefWritable cu = columns.get(i);
                int plainLen = cu.getLength();
                this.columnBufferSize += plainLen;
                int n = i;
                this.columnValuePlainLength[n] = this.columnValuePlainLength[n] + plainLen;
                this.columnBuffers[i].append(cu);
            }
            if (size < this.columnNumber) {
                for (i = columns.size(); i < this.columnNumber; ++i) {
                    this.columnBuffers[i].append(BytesRefWritable.ZeroBytesRefWritable);
                }
            }
            ++this.bufferedRecords;
            if (this.columnBufferSize > this.columnsBufferSize || this.bufferedRecords >= this.RECORD_INTERVAL) {
                this.flushRecords();
            }
        }

        private void flushRecords() throws IOException {
            this.key.numberRows = this.bufferedRecords;
            this.value.keyBuffer = this.key;
            int valueLength = 0;
            for (int columnIndex = 0; columnIndex < this.columnNumber; ++columnIndex) {
                int colLen;
                ColumnBuffer currentBuf = this.columnBuffers[columnIndex];
                currentBuf.flushGroup();
                NonSyncDataOutputBuffer columnValue = currentBuf.columnValBuffer;
                if (this.isCompressed()) {
                    this.compressionBuffer[columnIndex].reset();
                    this.deflateFilter[columnIndex].resetState();
                    this.deflateOut[columnIndex].write(columnValue.getData(), 0, columnValue.getLength());
                    this.deflateOut[columnIndex].flush();
                    this.deflateFilter[columnIndex].finish();
                    colLen = this.compressionBuffer[columnIndex].getLength();
                    this.key.setColumnLenInfo(colLen, currentBuf.valLenBuffer, this.columnValuePlainLength[columnIndex], columnIndex);
                    this.value.setColumnValueBuffer(this.compressionBuffer[columnIndex], columnIndex);
                    valueLength += colLen;
                } else {
                    colLen = this.columnValuePlainLength[columnIndex];
                    this.key.setColumnLenInfo(colLen, currentBuf.valLenBuffer, colLen, columnIndex);
                    this.value.setColumnValueBuffer(columnValue, columnIndex);
                    valueLength += colLen;
                }
                this.columnValuePlainLength[columnIndex] = 0;
            }
            int keyLength = this.key.getSize();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + this.key);
            }
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valueLength);
            this.out.writeInt(keyLength);
            if (!this.isCompressed()) {
                this.out.writeInt(keyLength);
                this.key.write((DataOutput)this.out);
            } else {
                this.keyCompressionBuffer.reset();
                this.keyDeflateFilter.resetState();
                this.key.write(this.keyDeflateOut);
                this.keyDeflateOut.flush();
                this.keyDeflateFilter.finish();
                int compressedKeyLen = this.keyCompressionBuffer.getLength();
                this.out.writeInt(compressedKeyLen);
                this.out.write(this.keyCompressionBuffer.getData(), 0, compressedKeyLen);
            }
            this.value.write((DataOutput)this.out);
            this.clearColumnBuffers();
            this.bufferedRecords = 0;
            this.columnBufferSize = 0;
        }

        private void clearColumnBuffers() throws IOException {
            for (int i = 0; i < this.columnNumber; ++i) {
                this.columnBuffers[i].clear();
            }
        }

        public synchronized void close() throws IOException {
            if (this.bufferedRecords > 0) {
                this.flushRecords();
            }
            this.clearColumnBuffers();
            if (this.isCompressed()) {
                for (int i = 0; i < this.columnNumber; ++i) {
                    this.deflateFilter[i].close();
                    IOUtils.closeStream((Closeable)this.deflateOut[i]);
                }
                this.keyDeflateFilter.close();
                IOUtils.closeStream((Closeable)this.keyDeflateOut);
                CodecPool.returnCompressor(this.keyCompressor);
                this.keyCompressor = null;
                CodecPool.returnCompressor(this.compressor);
                this.compressor = null;
            }
            if (this.out != null) {
                this.out.flush();
                this.out.close();
                this.out = null;
            }
        }

        class ColumnBuffer {
            NonSyncDataOutputBuffer columnValBuffer = new NonSyncDataOutputBuffer();
            NonSyncDataOutputBuffer valLenBuffer = new NonSyncDataOutputBuffer();
            int runLength = 0;
            int prevValueLength = -1;

            ColumnBuffer() throws IOException {
            }

            public void append(BytesRefWritable data) throws IOException {
                data.writeDataTo(this.columnValBuffer);
                int currentLen = data.getLength();
                if (this.prevValueLength < 0) {
                    this.startNewGroup(currentLen);
                    return;
                }
                if (currentLen != this.prevValueLength) {
                    this.flushGroup();
                    this.startNewGroup(currentLen);
                } else {
                    ++this.runLength;
                }
            }

            private void startNewGroup(int currentLen) {
                this.prevValueLength = currentLen;
                this.runLength = 0;
            }

            public void clear() throws IOException {
                this.valLenBuffer.reset();
                this.columnValBuffer.reset();
                this.prevValueLength = -1;
                this.runLength = 0;
            }

            public void flushGroup() throws IOException {
                if (this.prevValueLength >= 0) {
                    WritableUtils.writeVLong((DataOutput)this.valLenBuffer, (long)this.prevValueLength);
                    if (this.runLength > 0) {
                        WritableUtils.writeVLong((DataOutput)this.valLenBuffer, (long)(~this.runLength));
                    }
                    this.runLength = -1;
                    this.prevValueLength = -1;
                }
            }
        }
    }

    static class ValueBuffer
    implements Writable {
        private NonSyncDataOutputBuffer[] loadedColumnsValueBuffer = null;
        private boolean[] decompressedFlag = null;
        private LazyDecompressionCallbackImpl[] lazyDecompressCallbackObjs = null;
        boolean inited = false;
        KeyBuffer keyBuffer;
        private int columnNumber = 0;
        boolean[] skippedColIDs = null;
        CompressionCodec codec;
        Decompressor valDecompressor = null;
        NonSyncDataInputBuffer decompressBuffer = new NonSyncDataInputBuffer();
        CompressionInputStream deflatFilter = null;

        public ValueBuffer(KeyBuffer keyBuffer) throws IOException {
            this(keyBuffer, null);
        }

        public ValueBuffer(KeyBuffer keyBuffer, boolean[] skippedColIDs) throws IOException {
            this(keyBuffer, keyBuffer.columnNumber, skippedColIDs, null);
        }

        public ValueBuffer(KeyBuffer currentKey, int columnNumber, boolean[] skippedCols, CompressionCodec codec) throws IOException {
            this.keyBuffer = currentKey;
            this.columnNumber = columnNumber;
            if (skippedCols != null && skippedCols.length > 0) {
                this.skippedColIDs = skippedCols;
            } else {
                this.skippedColIDs = new boolean[columnNumber];
                for (int i = 0; i < this.skippedColIDs.length; ++i) {
                    this.skippedColIDs[i] = false;
                }
            }
            int skipped = 0;
            if (this.skippedColIDs != null) {
                for (boolean currentSkip : this.skippedColIDs) {
                    if (!currentSkip) continue;
                    ++skipped;
                }
            }
            this.loadedColumnsValueBuffer = new NonSyncDataOutputBuffer[columnNumber - skipped];
            this.decompressedFlag = new boolean[columnNumber - skipped];
            this.lazyDecompressCallbackObjs = new LazyDecompressionCallbackImpl[columnNumber - skipped];
            this.codec = codec;
            if (codec != null) {
                this.valDecompressor = CodecPool.getDecompressor(codec);
                this.deflatFilter = codec.createInputStream((InputStream)this.decompressBuffer, this.valDecompressor);
            }
            int readIndex = 0;
            for (int k = 0; k < columnNumber; ++k) {
                if (this.skippedColIDs[k]) continue;
                this.loadedColumnsValueBuffer[readIndex] = new NonSyncDataOutputBuffer();
                if (codec != null) {
                    this.decompressedFlag[readIndex] = false;
                    this.lazyDecompressCallbackObjs[readIndex] = new LazyDecompressionCallbackImpl(readIndex, k);
                } else {
                    this.decompressedFlag[readIndex] = true;
                }
                ++readIndex;
            }
        }

        public void setColumnValueBuffer(NonSyncDataOutputBuffer valBuffer, int addIndex) {
            this.loadedColumnsValueBuffer[addIndex] = valBuffer;
        }

        public void readFields(DataInput in) throws IOException {
            int addIndex = 0;
            int skipTotal = 0;
            for (int i = 0; i < this.columnNumber; ++i) {
                int vaRowsLen = this.keyBuffer.eachColumnValueLen[i];
                if (this.skippedColIDs[i]) {
                    skipTotal += vaRowsLen;
                    continue;
                }
                if (skipTotal != 0) {
                    in.skipBytes(skipTotal);
                    skipTotal = 0;
                }
                NonSyncDataOutputBuffer valBuf = this.loadedColumnsValueBuffer[addIndex];
                valBuf.reset();
                valBuf.write(in, vaRowsLen);
                if (this.codec != null) {
                    this.decompressedFlag[addIndex] = false;
                }
                ++addIndex;
            }
            if (skipTotal != 0) {
                in.skipBytes(skipTotal);
            }
        }

        public void write(DataOutput out) throws IOException {
            for (NonSyncDataOutputBuffer currentBuf : this.loadedColumnsValueBuffer) {
                out.write(currentBuf.getData(), 0, currentBuf.getLength());
            }
        }

        public void clearColumnBuffer() throws IOException {
            this.decompressBuffer.reset();
        }

        public void close() {
            for (NonSyncDataOutputBuffer element : this.loadedColumnsValueBuffer) {
                IOUtils.closeStream((Closeable)element);
            }
            if (this.codec != null) {
                IOUtils.closeStream((Closeable)this.decompressBuffer);
                CodecPool.returnDecompressor(this.valDecompressor);
            }
        }

        class LazyDecompressionCallbackImpl
        implements LazyDecompressionCallback {
            int index = -1;
            int colIndex = -1;

            public LazyDecompressionCallbackImpl(int index, int colIndex) {
                this.index = index;
                this.colIndex = colIndex;
            }

            @Override
            public byte[] decompress() throws IOException {
                if (ValueBuffer.this.decompressedFlag[this.index] || ValueBuffer.this.codec == null) {
                    return ValueBuffer.this.loadedColumnsValueBuffer[this.index].getData();
                }
                NonSyncDataOutputBuffer compressedData = ValueBuffer.this.loadedColumnsValueBuffer[this.index];
                NonSyncDataOutputBuffer decompressedData = new NonSyncDataOutputBuffer();
                ValueBuffer.this.decompressBuffer.reset();
                DataInputStream valueIn = new DataInputStream((InputStream)ValueBuffer.this.deflatFilter);
                ValueBuffer.this.deflatFilter.resetState();
                ValueBuffer.this.decompressBuffer.reset(compressedData.getData(), ValueBuffer.this.keyBuffer.eachColumnValueLen[this.colIndex]);
                decompressedData.write(valueIn, ValueBuffer.this.keyBuffer.eachColumnUncompressedValueLen[this.colIndex]);
                ((ValueBuffer)ValueBuffer.this).loadedColumnsValueBuffer[this.index] = decompressedData;
                ((ValueBuffer)ValueBuffer.this).decompressedFlag[this.index] = true;
                return decompressedData.getData();
            }
        }
    }

    static class KeyBuffer
    implements Writable {
        private int[] eachColumnValueLen = null;
        private int[] eachColumnUncompressedValueLen = null;
        private NonSyncDataOutputBuffer[] allCellValLenBuffer = null;
        private int numberRows = 0;
        private int columnNumber = 0;

        KeyBuffer(int columnNumber) {
            this(0, columnNumber);
        }

        KeyBuffer(int numberRows, int columnNum) {
            this.columnNumber = columnNum;
            this.eachColumnValueLen = new int[this.columnNumber];
            this.eachColumnUncompressedValueLen = new int[this.columnNumber];
            this.allCellValLenBuffer = new NonSyncDataOutputBuffer[this.columnNumber];
            this.numberRows = numberRows;
        }

        void setColumnLenInfo(int columnValueLen, NonSyncDataOutputBuffer colValLenBuffer, int columnUncompressedValueLen, int columnIndex) {
            this.eachColumnValueLen[columnIndex] = columnValueLen;
            this.eachColumnUncompressedValueLen[columnIndex] = columnUncompressedValueLen;
            this.allCellValLenBuffer[columnIndex] = colValLenBuffer;
        }

        public void readFields(DataInput in) throws IOException {
            this.eachColumnValueLen = new int[this.columnNumber];
            this.eachColumnUncompressedValueLen = new int[this.columnNumber];
            this.allCellValLenBuffer = new NonSyncDataOutputBuffer[this.columnNumber];
            this.numberRows = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < this.columnNumber; ++i) {
                this.eachColumnValueLen[i] = WritableUtils.readVInt((DataInput)in);
                this.eachColumnUncompressedValueLen[i] = WritableUtils.readVInt((DataInput)in);
                int bufLen = WritableUtils.readVInt((DataInput)in);
                if (this.allCellValLenBuffer[i] == null) {
                    this.allCellValLenBuffer[i] = new NonSyncDataOutputBuffer();
                } else {
                    this.allCellValLenBuffer[i].reset();
                }
                this.allCellValLenBuffer[i].write(in, bufLen);
            }
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong((DataOutput)out, (long)this.numberRows);
            for (int i = 0; i < this.eachColumnValueLen.length; ++i) {
                WritableUtils.writeVLong((DataOutput)out, (long)this.eachColumnValueLen[i]);
                WritableUtils.writeVLong((DataOutput)out, (long)this.eachColumnUncompressedValueLen[i]);
                NonSyncDataOutputBuffer colRowsLenBuf = this.allCellValLenBuffer[i];
                int bufLen = colRowsLenBuf.getLength();
                WritableUtils.writeVLong((DataOutput)out, (long)bufLen);
                out.write(colRowsLenBuf.getData(), 0, bufLen);
            }
        }

        public int getSize() throws IOException {
            int ret = 0;
            ret += WritableUtils.getVIntSize((long)this.numberRows);
            for (int i = 0; i < this.eachColumnValueLen.length; ++i) {
                ret += WritableUtils.getVIntSize((long)this.eachColumnValueLen[i]);
                ret += WritableUtils.getVIntSize((long)this.eachColumnUncompressedValueLen[i]);
                ret += WritableUtils.getVIntSize((long)this.allCellValLenBuffer[i].getLength());
                ret += this.allCellValLenBuffer[i].getLength();
            }
            return ret;
        }
    }
}

