/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, String> commandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType.get(tree.getToken().getType()));
        }
        switch (tree.getToken().getType()) {
            case 138: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 62: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 124: 
            case 136: 
            case 137: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 133: 
            case 134: {
                return new FunctionSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(138, "EXPLAIN");
        commandType.put(62, "LOAD");
        commandType.put(80, "CREATEDATABASE");
        commandType.put(106, "DROPDATABASE");
        commandType.put(105, "SWITCHDATABASE");
        commandType.put(81, "CREATETABLE");
        commandType.put(108, "DROPTABLE");
        commandType.put(83, "DESCTABLE");
        commandType.put(84, "DESCFUNCTION");
        commandType.put(99, "MSCK");
        commandType.put(86, "ALTERTABLE_ADDCOLS");
        commandType.put(88, "ALTERTABLE_REPLACECOLS");
        commandType.put(87, "ALTERTABLE_RENAMECOL");
        commandType.put(85, "ALTERTABLE_RENAME");
        commandType.put(90, "ALTERTABLE_DROPPARTS");
        commandType.put(89, "ALTERTABLE_ADDPARTS");
        commandType.put(91, "ALTERTABLE_TOUCH");
        commandType.put(92, "ALTERTABLE_ARCHIVE");
        commandType.put(93, "ALTERTABLE_UNARCHIVE");
        commandType.put(97, "ALTERTABLE_PROPERTIES");
        commandType.put(95, "ALTERTABLE_SERIALIZER");
        commandType.put(94, "ALTERTABLE_SERDEPROPERTIES");
        commandType.put(100, "SHOWDATABASES");
        commandType.put(101, "SHOWTABLES");
        commandType.put(104, "SHOW_TABLESTATUS");
        commandType.put(102, "SHOWFUNCTIONS");
        commandType.put(103, "SHOWPARTITIONS");
        commandType.put(133, "CREATEFUNCTION");
        commandType.put(134, "DROPFUNCTION");
        commandType.put(135, "CREATEVIEW");
        commandType.put(136, "DROPVIEW");
        commandType.put(137, "ALTERVIEW_PROPERTIES");
        commandType.put(5, "QUERY");
    }
}

