/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.DfsProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class CommandProcessorFactory {
    private CommandProcessorFactory() {
    }

    public static CommandProcessor get(String cmd) {
        String cmdl = cmd.toLowerCase();
        if ("set".equals(cmdl)) {
            return new SetProcessor();
        }
        if ("dfs".equals(cmdl)) {
            SessionState ss = SessionState.get();
            return new DfsProcessor(ss.getConf());
        }
        if ("add".equals(cmdl)) {
            return new AddResourceProcessor();
        }
        if ("delete".equals(cmdl)) {
            return new DeleteResourceProcessor();
        }
        if (!StringUtils.isBlank(cmd)) {
            return new Driver();
        }
        return null;
    }
}

