/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SetProcessor
implements CommandProcessor {
    private static String prefix = "set: ";

    public static boolean getBoolean(String value) {
        if (value.equals("on") || value.equals("true")) {
            return true;
        }
        if (value.equals("off") || value.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(prefix + "'" + value + "' is not a boolean");
    }

    private void dumpOptions(Properties p) {
        SessionState ss = SessionState.get();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.put("silent", ss.getIsSilent() ? "on" : "off");
        for (Object object : p.keySet()) {
            String oneProp = (String)object;
            String oneValue = p.getProperty(oneProp);
            sortedMap.put(oneProp, oneValue);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            ss.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    private void dumpOption(Properties p, String s) {
        SessionState ss = SessionState.get();
        if (p.getProperty(s) != null) {
            ss.out.println(s + "=" + p.getProperty(s));
        } else {
            ss.out.println(s + " is undefined");
        }
    }

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState ss = SessionState.get();
        String nwcmd = command.trim();
        if (nwcmd.equals("")) {
            this.dumpOptions(ss.getConf().getChangedProperties());
            return new CommandProcessorResponse(0);
        }
        if (nwcmd.equals("-v")) {
            this.dumpOptions(ss.getConf().getAllProperties());
            return new CommandProcessorResponse(0);
        }
        String[] part = new String[2];
        int eqIndex = nwcmd.indexOf(61);
        if (eqIndex == -1) {
            this.dumpOption(ss.getConf().getAllProperties(), nwcmd);
            return new CommandProcessorResponse(0);
        }
        if (eqIndex == nwcmd.length() - 1) {
            part[0] = nwcmd.substring(0, nwcmd.length() - 1);
            part[1] = "";
        } else {
            part[0] = nwcmd.substring(0, eqIndex).trim();
            part[1] = nwcmd.substring(eqIndex + 1).trim();
        }
        try {
            if (part[0].equals("silent")) {
                boolean val = SetProcessor.getBoolean(part[1]);
                ss.setIsSilent(val);
            } else {
                ss.getConf().set(part[0], part[1]);
            }
        }
        catch (IllegalArgumentException err) {
            ss.err.println(err.getMessage());
            return new CommandProcessorResponse(1);
        }
        return new CommandProcessorResponse(0);
    }
}

