/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="round", value="_FUNC_(x[, d]) - round x to d decimal places", extended="Example:\n  > SELECT _FUNC_(12.3456, 1) FROM src LIMIT 1;\n  12.3'")
public class UDFRound
extends UDF {
    private DoubleWritable doubleWritable = new DoubleWritable();
    private LongWritable longWritable = new LongWritable();

    public LongWritable evaluate(DoubleWritable n) {
        if (n == null) {
            return null;
        }
        this.longWritable.set(BigDecimal.valueOf(n.get()).setScale(0, RoundingMode.HALF_UP).longValue());
        return this.longWritable;
    }

    public DoubleWritable evaluate(DoubleWritable n, IntWritable i) {
        if (n == null || i == null) {
            return null;
        }
        this.doubleWritable.set(BigDecimal.valueOf(n.get()).setScale(i.get(), RoundingMode.HALF_UP).doubleValue());
        return this.doubleWritable;
    }
}

