/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="substr,substring", value="_FUNC_(str, pos[, len]) - returns the substring of str that starts at pos and is of length len", extended="pos is a 1-based index. If pos<0 the starting position is determined by counting backwards from the end of str.\nExample:\n   > SELECT _FUNC_('Facebook', 5) FROM src LIMIT 1;\n  'book'\n  > SELECT _FUNC_('Facebook', -5) FROM src LIMIT 1;\n  'ebook'\n  > SELECT _FUNC_('Facebook', 5, 1) FROM src LIMIT 1;\n  'b'")
public class UDFSubstr
extends UDF {
    private Text r;
    private IntWritable maxValue = new IntWritable(Integer.MAX_VALUE);

    public UDFSubstr() {
        this.r = new Text();
    }

    public Text evaluate(Text t, IntWritable pos, IntWritable len) {
        if (t == null || pos == null || len == null) {
            return null;
        }
        this.r.clear();
        if (len.get() <= 0) {
            return this.r;
        }
        String s = t.toString();
        if (Math.abs(pos.get()) > s.length()) {
            return this.r;
        }
        int start = pos.get() > 0 ? pos.get() - 1 : (pos.get() < 0 ? s.length() + pos.get() : 0);
        int end = s.length() - start < len.get() ? s.length() : start + len.get();
        this.r.set(s.substring(start, end));
        return this.r;
    }

    public Text evaluate(Text s, IntWritable pos) {
        return this.evaluate(s, pos, this.maxValue);
    }
}

