/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.util.ReflectionUtils;

public class GenericUDAFBridge
extends AbstractGenericUDAFResolver {
    UDAF udaf;

    public GenericUDAFBridge(UDAF udaf) {
        this.udaf = udaf;
    }

    public Class<? extends UDAF> getUDAFClass() {
        return this.udaf.getClass();
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        Class<? extends UDAFEvaluator> udafEvaluatorClass = this.udaf.getResolver().getEvaluatorClass(Arrays.asList(parameters));
        return new GenericUDAFBridgeEvaluator(udafEvaluatorClass);
    }

    public static class GenericUDAFBridgeEvaluator
    extends GenericUDAFEvaluator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Class<? extends UDAFEvaluator> udafEvaluator;
        transient ObjectInspector[] parameterOIs;
        transient Object result;
        transient Method iterateMethod;
        transient Method mergeMethod;
        transient Method terminatePartialMethod;
        transient Method terminateMethod;
        transient GenericUDFUtils.ConversionHelper conversionHelper;

        public GenericUDAFBridgeEvaluator() {
        }

        public Class<? extends UDAFEvaluator> getUdafEvaluator() {
            return this.udafEvaluator;
        }

        public void setUdafEvaluator(Class<? extends UDAFEvaluator> udafEvaluator) {
            this.udafEvaluator = udafEvaluator;
        }

        public GenericUDAFBridgeEvaluator(Class<? extends UDAFEvaluator> udafEvaluator) {
            this.udafEvaluator = udafEvaluator;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.parameterOIs = parameters;
            for (Method method : this.udafEvaluator.getMethods()) {
                if (method.getName().equals("iterate")) {
                    this.iterateMethod = method;
                }
                if (method.getName().equals("merge")) {
                    this.mergeMethod = method;
                }
                if (method.getName().equals("terminatePartial")) {
                    this.terminatePartialMethod = method;
                }
                if (!method.getName().equals("terminate")) continue;
                this.terminateMethod = method;
            }
            Method aggregateMethod = null;
            aggregateMethod = this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE ? this.iterateMethod : this.mergeMethod;
            this.conversionHelper = new GenericUDFUtils.ConversionHelper(aggregateMethod, parameters);
            Method evaluateMethod = null;
            evaluateMethod = this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? this.terminatePartialMethod : this.terminateMethod;
            Type returnType = evaluateMethod.getGenericReturnType();
            try {
                return ObjectInspectorFactory.getReflectionObjectInspector(returnType, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            }
            catch (RuntimeException e) {
                throw new HiveException("Cannot recognize return type " + returnType + " from " + evaluateMethod, e);
            }
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() {
            return new UDAFAgg((UDAFEvaluator)ReflectionUtils.newInstance(this.udafEvaluator, null));
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((UDAFAgg)agg).ueObject.init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            FunctionRegistry.invoke(this.iterateMethod, ((UDAFAgg)agg).ueObject, this.conversionHelper.convertIfNecessary(parameters));
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            FunctionRegistry.invoke(this.mergeMethod, ((UDAFAgg)agg).ueObject, this.conversionHelper.convertIfNecessary(partial));
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return FunctionRegistry.invoke(this.terminateMethod, ((UDAFAgg)agg).ueObject, new Object[0]);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return FunctionRegistry.invoke(this.terminatePartialMethod, ((UDAFAgg)agg).ueObject, new Object[0]);
        }

        static class UDAFAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            UDAFEvaluator ueObject;

            UDAFAgg(UDAFEvaluator ueObject) {
                this.ueObject = ueObject;
            }
        }
    }
}

