/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util.jdbm.recman;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.hive.ql.util.jdbm.recman.BlockIo;
import org.apache.hadoop.hive.ql.util.jdbm.recman.TransactionManager;

public final class RecordFile {
    final TransactionManager txnMgr;
    private final LinkedList free = new LinkedList();
    private final HashMap inUse = new HashMap();
    private final HashMap dirty = new HashMap();
    private final HashMap inTxn = new HashMap();
    private boolean transactionsDisabled = false;
    public static final int BLOCK_SIZE = 8192;
    static final String extension = ".db";
    static final byte[] cleanData = new byte[8192];
    private RandomAccessFile file;
    private final String fileName;

    RecordFile(String fileName) throws IOException {
        this.fileName = fileName;
        this.file = new RandomAccessFile(fileName + extension, "rw");
        this.txnMgr = new TransactionManager(this);
    }

    RecordFile(File file) throws IOException {
        this.fileName = file.getName();
        this.file = new RandomAccessFile(file, "rw");
        this.txnMgr = new TransactionManager(this);
    }

    String getFileName() {
        return this.fileName;
    }

    void disableTransactions() {
        this.transactionsDisabled = true;
    }

    BlockIo get(long blockid) throws IOException {
        Long key = new Long(blockid);
        BlockIo node = (BlockIo)this.inTxn.get(key);
        if (node != null) {
            this.inTxn.remove(key);
            this.inUse.put(key, node);
            return node;
        }
        node = (BlockIo)this.dirty.get(key);
        if (node != null) {
            this.dirty.remove(key);
            this.inUse.put(key, node);
            return node;
        }
        Iterator i = this.free.iterator();
        while (i.hasNext()) {
            BlockIo cur = (BlockIo)i.next();
            if (cur.getBlockId() != blockid) continue;
            node = cur;
            i.remove();
            this.inUse.put(key, node);
            return node;
        }
        if (this.inUse.get(key) != null) {
            throw new Error("double get for block " + blockid);
        }
        node = this.getNewNode(blockid);
        long offset = blockid * 8192L;
        if (this.file.length() > 0L && offset <= this.file.length()) {
            RecordFile.read(this.file, offset, node.getData(), 8192);
        } else {
            System.arraycopy(cleanData, 0, node.getData(), 0, 8192);
        }
        this.inUse.put(key, node);
        node.setClean();
        return node;
    }

    void release(long blockid, boolean isDirty) throws IOException {
        BlockIo node = (BlockIo)this.inUse.get(new Long(blockid));
        if (node == null) {
            throw new IOException("bad blockid " + blockid + " on release");
        }
        if (!node.isDirty() && isDirty) {
            node.setDirty();
        }
        this.release(node);
    }

    void release(BlockIo block) {
        Long key = new Long(block.getBlockId());
        this.inUse.remove(key);
        if (block.isDirty()) {
            this.dirty.put(key, block);
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(key, block);
        } else {
            this.free.add(block);
        }
    }

    void discard(BlockIo block) {
        Long key = new Long(block.getBlockId());
        this.inUse.remove(key);
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.values().iterator());
            throw new Error("in use list not empty at commit time (" + this.inUse.size() + ")");
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.start();
        }
        Iterator i = this.dirty.values().iterator();
        while (i.hasNext()) {
            BlockIo node = (BlockIo)i.next();
            i.remove();
            if (this.transactionsDisabled) {
                long offset = node.getBlockId() * 8192L;
                this.file.seek(offset);
                this.file.write(node.getData());
                node.setClean();
                this.free.add(node);
                continue;
            }
            this.txnMgr.add(node);
            this.inTxn.put(new Long(node.getBlockId()), node);
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.values().iterator());
            throw new Error("in use list not empty at rollback time (" + this.inUse.size() + ")");
        }
        this.dirty.clear();
        this.txnMgr.synchronizeLogFromDisk();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error("in txn list not empty at rollback time (" + this.inTxn.size() + ")");
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        this.txnMgr.shutdown();
        if (this.transactionsDisabled) {
            this.txnMgr.removeLogFile();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error("In transaction not empty");
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.values().iterator());
            throw new Error("Dirty blocks at close time");
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.values().iterator());
            throw new Error("inUse blocks at close time");
        }
        this.file.close();
        this.file = null;
    }

    void forceClose() throws IOException {
        this.txnMgr.forceClose();
        this.file.close();
    }

    private void showList(Iterator i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    private BlockIo getNewNode(long blockid) throws IOException {
        BlockIo retval = null;
        if (!this.free.isEmpty()) {
            retval = (BlockIo)this.free.removeFirst();
        }
        if (retval == null) {
            retval = new BlockIo(0L, new byte[8192]);
        }
        retval.setBlockId(blockid);
        retval.setView(null);
        return retval;
    }

    void synch(BlockIo node) throws IOException {
        byte[] data = node.getData();
        if (data != null) {
            long offset = node.getBlockId() * 8192L;
            this.file.seek(offset);
            this.file.write(data);
        }
    }

    void releaseFromTransaction(BlockIo node, boolean recycle) throws IOException {
        Long key = new Long(node.getBlockId());
        if (this.inTxn.remove(key) != null && recycle) {
            this.free.add(node);
        }
    }

    void sync() throws IOException {
        this.file.getFD().sync();
    }

    private static void read(RandomAccessFile file, long offset, byte[] buffer, int nBytes) throws IOException {
        file.seek(offset);
        int remaining = nBytes;
        int pos = 0;
        while (remaining > 0) {
            int read = file.read(buffer, pos, remaining);
            if (read == -1) {
                System.arraycopy(cleanData, 0, buffer, pos, remaining);
                break;
            }
            remaining -= read;
            pos += read;
        }
    }
}

