/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.MiniDFSCluster;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;

public class Hadoop18Shims
implements HadoopShims {
    String[] ret = new String[2];

    @Override
    public boolean usesJobShell() {
        return true;
    }

    @Override
    public boolean fileSystemDeleteOnExit(FileSystem fs, Path path) throws IOException {
        return fs.deleteOnExit(path);
    }

    @Override
    public void inputFormatValidateInput(InputFormat fmt, JobConf conf) throws IOException {
    }

    @Override
    public boolean isJobPreparing(RunningJob job) throws IOException {
        return false;
    }

    @Override
    public void setTmpFiles(String prop, String files) {
        Configuration conf = JobClient.getCommandLineConfig();
        if (conf != null) {
            conf.set(prop, files);
        }
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    @Override
    public int compareText(Text a, Text b) {
        return a.compareTo((Object)b);
    }

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return null;
    }

    @Override
    public String getInputFormatClassName() {
        return "org.apache.hadoop.hive.ql.io.HiveInputFormat";
    }

    @Override
    public String[] getTaskJobIDs(TaskCompletionEvent t) {
        TaskID tid = t.getTaskAttemptId().getTaskID();
        this.ret[0] = tid.toString();
        this.ret[1] = tid.getJobID().toString();
        return this.ret;
    }

    @Override
    public long getAccessTime(FileStatus file) {
        return -1L;
    }

    @Override
    public void setFloatConf(Configuration conf, String varName, float val) {
        conf.set(varName, Float.toString(val));
    }

    @Override
    public int createHadoopArchive(Configuration conf, Path parentDir, Path destDir, String archiveName) throws Exception {
        throw new RuntimeException("Not implemented in this Hadoop version");
    }

    @Override
    public void setNullOutputFormat(JobConf conf) {
        conf.setOutputFormat(NullOutputFormat.class);
    }

    @Override
    public UserGroupInformation getUGIForConf(Configuration conf) throws LoginException {
        UnixUserGroupInformation ugi = UnixUserGroupInformation.readFromConf((Configuration)conf, (String)"hadoop.job.ugi");
        if (ugi == null) {
            ugi = UserGroupInformation.login((Configuration)conf);
        }
        return ugi;
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }
}

