/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.LazyHBaseRow;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class HBaseSerDe
implements SerDe {
    public static final String HBASE_COL_MAPPING = "hbase.columns.mapping";
    public static final String HBASE_TABLE_NAME = "hbase.table.name";
    public static final String HBASE_KEY_COL = ":key";
    public static final Log LOG = LogFactory.getLog((String)HBaseSerDe.class.getName());
    private ObjectInspector cachedObjectInspector;
    private List<String> hbaseColumnNames;
    private LazySimpleSerDe.SerDeParameters serdeParams;
    private boolean useJSONSerialize;
    private LazyHBaseRow cachedHBaseRow;
    private ByteStream.Output serializeStream = new ByteStream.Output();
    private int iKey;

    public String toString() {
        return this.getClass().toString() + "[" + this.hbaseColumnNames + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames() + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos() + "]";
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.initHBaseSerDeParameters(conf, tbl, this.getClass().getName());
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector((List)this.serdeParams.getColumnNames(), (List)this.serdeParams.getColumnTypes(), (byte[])this.serdeParams.getSeparators(), (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isLastColumnTakesRest(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
        this.cachedHBaseRow = new LazyHBaseRow((LazySimpleStructObjectInspector)this.cachedObjectInspector);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HBaseSerDe initialized with : columnNames = " + this.serdeParams.getColumnNames() + " columnTypes = " + this.serdeParams.getColumnTypes() + " hbaseColumnMapping = " + this.hbaseColumnNames));
        }
    }

    public static List<String> parseColumnMapping(String columnMapping) {
        String[] columnArray = columnMapping.split(",");
        List<String> columnList = Arrays.asList(columnArray);
        int iKey = columnList.indexOf(HBASE_KEY_COL);
        if (iKey == -1) {
            columnList = new ArrayList<String>(columnList);
            columnList.add(0, HBASE_KEY_COL);
        }
        return columnList;
    }

    public static boolean isSpecialColumn(String hbaseColumnName) {
        return hbaseColumnName.equals(HBASE_KEY_COL);
    }

    private void initHBaseSerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        String hbaseColumnNameProperty = tbl.getProperty(HBASE_COL_MAPPING);
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.hbaseColumnNames = HBaseSerDe.parseColumnMapping(hbaseColumnNameProperty);
        this.iKey = this.hbaseColumnNames.indexOf(HBASE_KEY_COL);
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.hbaseColumnNames.size(); ++i) {
                String colName;
                if (sb.length() > 0) {
                    sb.append(":");
                }
                if (HBaseSerDe.isSpecialColumn(colName = this.hbaseColumnNames.get(i))) {
                    sb.append("string");
                    continue;
                }
                if (colName.endsWith(":")) {
                    sb.append("map<string,string>");
                    continue;
                }
                sb.append("string");
            }
            tbl.setProperty("columns.types", sb.toString());
        }
        this.serdeParams = LazySimpleSerDe.initSerdeParams((Configuration)job, (Properties)tbl, (String)serdeName);
        if (this.hbaseColumnNames.size() != this.serdeParams.getColumnNames().size()) {
            throw new SerDeException(serdeName + ": columns has " + this.serdeParams.getColumnNames().size() + " elements while hbase.columns.mapping has " + this.hbaseColumnNames.size() + " elements" + " (counting the key if implicit)");
        }
        for (int i = 0; i < this.hbaseColumnNames.size(); ++i) {
            TypeInfo typeInfo;
            String hbaseColName = this.hbaseColumnNames.get(i);
            if (!hbaseColName.endsWith(":") || (typeInfo = (TypeInfo)this.serdeParams.getColumnTypes().get(i)).getCategory() == ObjectInspector.Category.MAP && ((MapTypeInfo)typeInfo).getMapKeyTypeInfo().getTypeName() == "string") continue;
            throw new SerDeException(serdeName + ": hbase column family '" + hbaseColName + "' should be mapped to map<string,?> but is mapped to " + typeInfo.getTypeName());
        }
    }

    public Object deserialize(Writable rowResult) throws SerDeException {
        if (!(rowResult instanceof RowResult)) {
            throw new SerDeException(this.getClass().getName() + ": expects RowResult!");
        }
        RowResult rr = (RowResult)rowResult;
        this.cachedHBaseRow.init(rr, this.hbaseColumnNames);
        return this.cachedHBaseRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return BatchUpdate.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        BatchUpdate batchUpdate;
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List list = soi.getStructFieldsDataAsList(obj);
        List declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        try {
            byte[] key = this.serializeField(this.iKey, HBASE_KEY_COL, null, fields, list, declaredFields);
            if (key == null) {
                throw new SerDeException("HBase row key cannot be NULL");
            }
            batchUpdate = new BatchUpdate(key);
            for (int i = 0; i < fields.size(); ++i) {
                if (i == this.iKey) continue;
                String hbaseColumn = this.hbaseColumnNames.get(i);
                this.serializeField(i, hbaseColumn, batchUpdate, fields, list, declaredFields);
            }
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return batchUpdate;
    }

    private byte[] serializeField(int i, String hbaseColumn, BatchUpdate batchUpdate, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        Object f;
        ObjectInspector foi = fields.get(i).getFieldObjectInspector();
        Object object = f = list == null ? null : list.get(i);
        if (f == null) {
            return null;
        }
        if (hbaseColumn.endsWith(":")) {
            MapObjectInspector moi = (MapObjectInspector)foi;
            ObjectInspector koi = moi.getMapKeyObjectInspector();
            ObjectInspector voi = moi.getMapValueObjectInspector();
            Map map = moi.getMap(f);
            if (map == null) {
                return null;
            }
            for (Map.Entry entry : map.entrySet()) {
                this.serializeStream.reset();
                HBaseSerDe.serialize(this.serializeStream, entry.getKey(), koi, this.serdeParams.getSeparators(), 3, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
                String hbaseSparseColumn = hbaseColumn + Bytes.toString((byte[])this.serializeStream.getData(), (int)0, (int)this.serializeStream.getCount());
                this.serializeStream.reset();
                boolean isNotNull = HBaseSerDe.serialize(this.serializeStream, entry.getValue(), voi, this.serdeParams.getSeparators(), 3, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
                if (!isNotNull) continue;
                byte[] key = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, key, 0, this.serializeStream.getCount());
                batchUpdate.put(hbaseSparseColumn, key);
            }
        } else {
            this.serializeStream.reset();
            boolean isNotNull = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && (declaredFields == null || declaredFields.get(i).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize) ? HBaseSerDe.serialize(this.serializeStream, SerDeUtils.getJSONString((Object)f, (ObjectInspector)foi), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, this.serdeParams.getSeparators(), 1, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape()) : HBaseSerDe.serialize(this.serializeStream, f, foi, this.serdeParams.getSeparators(), 1, this.serdeParams.getNullSequence(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
            if (!isNotNull) {
                return null;
            }
            byte[] key = new byte[this.serializeStream.getCount()];
            System.arraycopy(this.serializeStream.getData(), 0, key, 0, this.serializeStream.getCount());
            if (hbaseColumn.equals(HBASE_KEY_COL)) {
                return key;
            }
            batchUpdate.put(hbaseColumn, key);
        }
        return null;
    }

    public static boolean serialize(ByteStream.Output out, Object obj, ObjectInspector objInspector, byte[] separators, int level, Text nullSequence, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)out, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)escaped, (byte)escapeChar, (boolean[])needsEscape);
                return true;
            }
            case LIST: {
                char separator = (char)separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        out.write((int)separator);
                    }
                    HBaseSerDe.serialize(out, list.get(i), eoi, separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                }
                return true;
            }
            case MAP: {
                char separator = (char)separators[level];
                char keyValueSeparator = (char)separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        out.write((int)separator);
                    }
                    HBaseSerDe.serialize(out, entry.getKey(), koi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                    out.write((int)keyValueSeparator);
                    HBaseSerDe.serialize(out, entry.getValue(), voi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                }
                return true;
            }
            case STRUCT: {
                char separator = (char)separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        out.write((int)separator);
                    }
                    HBaseSerDe.serialize(out, list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
    }

    public boolean isUseJSONSerialize() {
        return this.useJSONSerialize;
    }

    public void setUseJSONSerialize(boolean useJSONSerialize) {
        this.useJSONSerialize = useJSONSerialize;
    }
}

