/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapred.TableSplit;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class HBaseSplit
extends FileSplit
implements InputSplit {
    private String hbaseColumnMapping;
    private TableSplit split;

    public HBaseSplit() {
        super((Path)null, 0L, 0L, (String[])null);
        this.hbaseColumnMapping = "";
        this.split = new TableSplit();
    }

    public HBaseSplit(TableSplit split, String columnsMapping, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.split = split;
        this.hbaseColumnMapping = columnsMapping;
    }

    public TableSplit getSplit() {
        return this.split;
    }

    public String getColumnsMapping() {
        return this.hbaseColumnMapping;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.hbaseColumnMapping = in.readUTF();
        this.split.readFields(in);
    }

    public String toString() {
        return "TableSplit " + this.split + " : " + this.hbaseColumnMapping;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.hbaseColumnMapping);
        this.split.write(out);
    }

    public long getLength() {
        return this.split.getLength();
    }

    public String[] getLocations() throws IOException {
        return this.split.getLocations();
    }
}

