/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class LazyHBaseRow
extends LazyStruct {
    private List<String> hbaseColumns;
    private RowResult rowResult;
    private ArrayList<Object> cachedList;

    public LazyHBaseRow(LazySimpleStructObjectInspector oi) {
        super(oi);
    }

    public void init(RowResult rr, List<String> hbaseColumns) {
        this.rowResult = rr;
        this.hbaseColumns = hbaseColumns;
        this.setParsed(false);
    }

    private void parse() {
        if (this.getFields() == null) {
            List fieldRefs = ((StructObjectInspector)this.getInspector()).getAllStructFieldRefs();
            this.setFields(new LazyObject[fieldRefs.size()]);
            for (int i = 0; i < this.getFields().length; ++i) {
                String hbaseColumn = this.hbaseColumns.get(i);
                this.getFields()[i] = hbaseColumn.endsWith(":") ? new LazyHBaseCellMap((LazyMapObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector()) : LazyFactory.createLazyObject((ObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector());
            }
            this.setFieldInited(new boolean[this.getFields().length]);
        }
        Arrays.fill(this.getFieldInited(), false);
        this.setParsed(true);
    }

    public Object getField(int fieldID) {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        if (!this.getFieldInited()[fieldID]) {
            this.getFieldInited()[fieldID] = true;
            ByteArrayRef ref = null;
            String columnName = this.hbaseColumns.get(fieldID);
            if (columnName.equals(":key")) {
                ref = new ByteArrayRef();
                ref.setData(this.rowResult.getRow());
            } else if (columnName.endsWith(":")) {
                ((LazyHBaseCellMap)this.getFields()[fieldID]).init(this.rowResult, columnName);
            } else if (this.rowResult.containsKey(columnName)) {
                ref = new ByteArrayRef();
                ref.setData(this.rowResult.get(columnName).getValue());
            } else {
                return null;
            }
            if (ref != null) {
                this.getFields()[fieldID].init(ref, 0, ref.getData().length);
            }
        }
        return this.getFields()[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.getParsed()) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

