/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.management;

import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ManagementManager {
    private final OMFContext omfContext;
    private boolean closed = false;
    private ManagementServer mgmtServer;

    public ManagementManager(OMFContext ctxt) {
        this.omfContext = ctxt;
        this.startManagementServer();
    }

    public ManagementServer getManagementServer() {
        return this.mgmtServer;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized void close() {
        this.assertNotClosed();
        this.stopManagementServer();
        this.closed = true;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new NucleusException("Management instance is closed and cannot be used. You must adquire a new OMFContext").setFatal();
        }
    }

    private void startManagementServer() {
        if (this.mgmtServer == null) {
            try {
                this.mgmtServer = (ManagementServer)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.management_server", "name", "default", "class", null, null);
                if (this.mgmtServer != null) {
                    NucleusLogger.MANAGEMENT.info("Starting Management Server");
                    this.mgmtServer.start();
                }
            }
            catch (Exception e) {
                this.mgmtServer = null;
                NucleusLogger.MANAGEMENT.error("Error instantiating or connecting to Management Server : " + StringUtils.getStringFromStackTrace(e));
            }
        }
    }

    private void stopManagementServer() {
        if (this.mgmtServer != null) {
            NucleusLogger.MANAGEMENT.info("Stopping Management Server");
            this.mgmtServer.stop();
        }
    }
}

