/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public class PersistFieldManager
extends AbstractFieldManager {
    private final StateManager sm;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(StateManager sm, boolean replaceSCOsWithWrappers) {
        this.sm = sm;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    protected void processPersistable(Object pc, int ownerFieldNum, int objectType) {
        ApiAdapter adapter = this.sm.getObjectManager().getApiAdapter();
        if (!adapter.isPersistent(pc) || adapter.isPersistent(pc) && adapter.isDeleted(pc)) {
            if (objectType != 0) {
                this.sm.getObjectManager().persistObjectInternal(pc, null, this.sm, ownerFieldNum, objectType);
            } else {
                this.sm.getObjectManager().persistObjectInternal(pc, null, null, -1, objectType);
            }
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        block19: {
            boolean[] secondClassMutableFieldFlags;
            if (value == null) break block19;
            AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            boolean persistCascade = fmd.isCascadePersist();
            ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
            if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.sm.getClassMetaData().getSCOMutableMemberFlags())[fieldNumber] && !(value instanceof SCO)) {
                this.sm.wrapSCOField(fieldNumber, value, false, true, true);
            }
            if (persistCascade) {
                if (api.isPersistable(value)) {
                    if (fmd.isEmbedded() || fmd.isSerialized()) {
                        this.processPersistable(value, fieldNumber, 1);
                    } else {
                        this.processPersistable(value, -1, 0);
                    }
                } else if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    for (Object element : coll) {
                        if (!api.isPersistable(element)) continue;
                        if (fmd.getCollection().isEmbeddedElement() || fmd.getCollection().isSerializedElement()) {
                            this.processPersistable(element, fieldNumber, 2);
                            continue;
                        }
                        this.processPersistable(element, -1, 0);
                    }
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    Set keys = map.keySet();
                    for (Object mapKey : keys) {
                        if (!api.isPersistable(mapKey)) continue;
                        if (fmd.getMap().isEmbeddedKey() || fmd.getMap().isSerializedKey()) {
                            this.processPersistable(mapKey, fieldNumber, 3);
                            continue;
                        }
                        this.processPersistable(mapKey, -1, 0);
                    }
                    Collection values = map.values();
                    for (Object mapValue : values) {
                        if (!api.isPersistable(mapValue)) continue;
                        if (fmd.getMap().isEmbeddedValue() || fmd.getMap().isSerializedValue()) {
                            this.processPersistable(mapValue, fieldNumber, 4);
                            continue;
                        }
                        this.processPersistable(mapValue, -1, 0);
                    }
                } else if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object element = array[i];
                        if (!api.isPersistable(element)) continue;
                        if (fmd.getArray().isEmbeddedElement() || fmd.getArray().isSerializedElement()) {
                            this.processPersistable(element, fieldNumber, 2);
                            continue;
                        }
                        this.processPersistable(element, -1, 0);
                    }
                }
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }
}

