/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.api.AdjacencyType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Adjacency
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Adjacency");
    private static final TField NODE_FIELD_DESC = new TField("node", 11, 1);
    private static final TField CHILDREN_FIELD_DESC = new TField("children", 15, 2);
    private static final TField ADJACENCY_TYPE_FIELD_DESC = new TField("adjacencyType", 8, 3);
    private String node;
    public static final int NODE = 1;
    private List<String> children;
    public static final int CHILDREN = 2;
    private int adjacencyType;
    public static final int ADJACENCYTYPE = 3;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("node", 3, new FieldValueMetaData(11)));
            this.put(2, new FieldMetaData("children", 3, new ListMetaData(15, new FieldValueMetaData(11))));
            this.put(3, new FieldMetaData("adjacencyType", 3, new FieldValueMetaData(8)));
        }
    });

    public Adjacency() {
    }

    public Adjacency(String node, List<String> children, int adjacencyType) {
        this();
        this.node = node;
        this.children = children;
        this.adjacencyType = adjacencyType;
        this.__isset.adjacencyType = true;
    }

    public Adjacency(Adjacency other) {
        if (other.isSetNode()) {
            this.node = other.node;
        }
        if (other.isSetChildren()) {
            ArrayList<String> __this__children = new ArrayList<String>();
            for (String other_element : other.children) {
                __this__children.add(other_element);
            }
            this.children = __this__children;
        }
        this.__isset.adjacencyType = other.__isset.adjacencyType;
        this.adjacencyType = other.adjacencyType;
    }

    public Adjacency clone() {
        return new Adjacency(this);
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void unsetNode() {
        this.node = null;
    }

    public boolean isSetNode() {
        return this.node != null;
    }

    public int getChildrenSize() {
        return this.children == null ? 0 : this.children.size();
    }

    public Iterator<String> getChildrenIterator() {
        return this.children == null ? null : this.children.iterator();
    }

    public void addToChildren(String elem) {
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(elem);
    }

    public List<String> getChildren() {
        return this.children;
    }

    public void setChildren(List<String> children) {
        this.children = children;
    }

    public void unsetChildren() {
        this.children = null;
    }

    public boolean isSetChildren() {
        return this.children != null;
    }

    public int getAdjacencyType() {
        return this.adjacencyType;
    }

    public void setAdjacencyType(int adjacencyType) {
        this.adjacencyType = adjacencyType;
        this.__isset.adjacencyType = true;
    }

    public void unsetAdjacencyType() {
        this.__isset.adjacencyType = false;
    }

    public boolean isSetAdjacencyType() {
        return this.__isset.adjacencyType;
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetNode();
                    break;
                }
                this.setNode((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetChildren();
                    break;
                }
                this.setChildren((List)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetAdjacencyType();
                    break;
                }
                this.setAdjacencyType((Integer)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getNode();
            }
            case 2: {
                return this.getChildren();
            }
            case 3: {
                return this.getAdjacencyType();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetNode();
            }
            case 2: {
                return this.isSetChildren();
            }
            case 3: {
                return this.isSetAdjacencyType();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Adjacency) {
            return this.equals((Adjacency)that);
        }
        return false;
    }

    public boolean equals(Adjacency that) {
        if (that == null) {
            return false;
        }
        boolean this_present_node = this.isSetNode();
        boolean that_present_node = that.isSetNode();
        if (this_present_node || that_present_node) {
            if (!this_present_node || !that_present_node) {
                return false;
            }
            if (!this.node.equals(that.node)) {
                return false;
            }
        }
        boolean this_present_children = this.isSetChildren();
        boolean that_present_children = that.isSetChildren();
        if (this_present_children || that_present_children) {
            if (!this_present_children || !that_present_children) {
                return false;
            }
            if (!((Object)this.children).equals(that.children)) {
                return false;
            }
        }
        boolean this_present_adjacencyType = true;
        boolean that_present_adjacencyType = true;
        if (this_present_adjacencyType || that_present_adjacencyType) {
            if (!this_present_adjacencyType || !that_present_adjacencyType) {
                return false;
            }
            if (this.adjacencyType != that.adjacencyType) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.node = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.children = new ArrayList<String>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            String _elem2 = iprot.readString();
                            this.children.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.adjacencyType = iprot.readI32();
                        this.__isset.adjacencyType = true;
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.node != null) {
            oprot.writeFieldBegin(NODE_FIELD_DESC);
            oprot.writeString(this.node);
            oprot.writeFieldEnd();
        }
        if (this.children != null) {
            oprot.writeFieldBegin(CHILDREN_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.children.size()));
            for (String _iter3 : this.children) {
                oprot.writeString(_iter3);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(ADJACENCY_TYPE_FIELD_DESC);
        oprot.writeI32(this.adjacencyType);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Adjacency(");
        boolean first = true;
        sb.append("node:");
        if (this.node == null) {
            sb.append("null");
        } else {
            sb.append(this.node);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("children:");
        if (this.children == null) {
            sb.append("null");
        } else {
            sb.append(this.children);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("adjacencyType:");
        String adjacencyType_name = AdjacencyType.VALUES_TO_NAMES.get(this.adjacencyType);
        if (adjacencyType_name != null) {
            sb.append(adjacencyType_name);
            sb.append(" (");
        }
        sb.append(this.adjacencyType);
        if (adjacencyType_name != null) {
            sb.append(")");
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetAdjacencyType() && !AdjacencyType.VALID_VALUES.contains(this.adjacencyType)) {
            throw new TProtocolException("The field 'adjacencyType' has been assigned the invalid value " + this.adjacencyType);
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(Adjacency.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean adjacencyType = false;

        private Isset() {
        }
    }
}

