/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util.jdbm;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.util.jdbm.RecordManager;
import org.apache.hadoop.hive.ql.util.jdbm.RecordManagerProvider;

public final class RecordManagerFactory {
    public static RecordManager createRecordManager(String name) throws IOException {
        return RecordManagerFactory.createRecordManager(name, new Properties());
    }

    public static RecordManager createRecordManager(String name, Properties options) throws IOException {
        RecordManagerProvider factory = RecordManagerFactory.getFactory(options);
        return factory.createRecordManager(name, options);
    }

    public static RecordManager createRecordManager(File file, Properties options) throws IOException {
        RecordManagerProvider factory = RecordManagerFactory.getFactory(options);
        return factory.createRecordManager(file, options);
    }

    private static RecordManagerProvider getFactory(Properties options) {
        RecordManagerProvider factory;
        String provider = options.getProperty("jdbm.provider", "org.apache.hadoop.hive.ql.util.jdbm.recman.Provider");
        try {
            Class<?> clazz = Class.forName(provider);
            factory = (RecordManagerProvider)clazz.newInstance();
        }
        catch (Exception except) {
            throw new IllegalArgumentException("Invalid record manager provider: " + provider + "\n[" + except.getClass().getName() + ": " + except.getMessage() + "]");
        }
        return factory;
    }
}

