/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerTransport;

public class THsHaServer
extends TNonblockingServer {
    private ExecutorService invoker;
    protected final int MIN_WORKER_THREADS;
    protected final int MAX_WORKER_THREADS;
    protected final int STOP_TIMEOUT_VAL;
    protected final TimeUnit STOP_TIMEOUT_UNIT;

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport) {
        this(processor, serverTransport, new Options());
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, Options options) {
        this(new TProcessorFactory(processor), serverTransport, options);
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport) {
        this(processorFactory, serverTransport, new Options());
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, Options options) {
        this(processorFactory, serverTransport, new TFramedTransport.Factory(), new TBinaryProtocol.Factory(), options);
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, protocolFactory, new Options());
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory, Options options) {
        this(processor, serverTransport, new TFramedTransport.Factory(), protocolFactory);
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, transportFactory, protocolFactory);
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory, new Options());
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory transportFactory, TProtocolFactory protocolFactory, Options options) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory, options);
    }

    public THsHaServer(TProcessor processor, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, new Options());
    }

    public THsHaServer(TProcessorFactory processorFactory, TNonblockingServerTransport serverTransport, TFramedTransport.Factory inputTransportFactory, TFramedTransport.Factory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, options);
        this.MIN_WORKER_THREADS = options.minWorkerThreads;
        this.MAX_WORKER_THREADS = options.maxWorkerThreads;
        this.STOP_TIMEOUT_VAL = options.stopTimeoutVal;
        this.STOP_TIMEOUT_UNIT = options.stopTimeoutUnit;
    }

    public void serve() {
        if (!this.startInvokerPool()) {
            return;
        }
        if (!this.startListening()) {
            return;
        }
        if (!this.startSelectorThread()) {
            return;
        }
        this.joinSelector();
        this.gracefullyShutdownInvokerPool();
        this.stopListening();
    }

    protected boolean startInvokerPool() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.invoker = new ThreadPoolExecutor(this.MIN_WORKER_THREADS, this.MAX_WORKER_THREADS, this.STOP_TIMEOUT_VAL, this.STOP_TIMEOUT_UNIT, queue);
        return true;
    }

    protected void gracefullyShutdownInvokerPool() {
        long newnow;
        this.invoker.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = 10000L; timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.invoker.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    protected void requestInvoke(TNonblockingServer.FrameBuffer frameBuffer) {
        this.invoker.execute(new Invocation(frameBuffer));
    }

    public static class Options
    extends TNonblockingServer.Options {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
    }

    private class Invocation
    implements Runnable {
        private final TNonblockingServer.FrameBuffer frameBuffer;

        public Invocation(TNonblockingServer.FrameBuffer frameBuffer) {
            this.frameBuffer = frameBuffer;
        }

        public void run() {
            this.frameBuffer.invoke();
        }
    }
}

