/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveMetaStoreClient
implements IMetaStoreClient {
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean open = false;
    private URI[] metastoreUris;
    private boolean standAloneClient = false;
    private int retries = 5;
    private static final Log LOG = LogFactory.getLog((String)"hive.metastore");

    public HiveMetaStoreClient(HiveConf conf) throws MetaException {
        boolean localMetaStore;
        if (conf == null) {
            conf = new HiveConf(HiveMetaStoreClient.class);
        }
        if (localMetaStore = conf.getBoolean("hive.metastore.local", false)) {
            this.client = new HiveMetaStore.HMSHandler("hive client", conf);
            this.open = true;
            return;
        }
        this.retries = conf.getInt("hive.metastore.connect.retries", 5);
        if (conf.getVar(HiveConf.ConfVars.METASTOREURIS) != null) {
            String[] metastoreUrisString = conf.getVar(HiveConf.ConfVars.METASTOREURIS).split(",");
            this.metastoreUris = new URI[metastoreUrisString.length];
            try {
                int i = 0;
                for (String s : metastoreUrisString) {
                    URI tmpUri = new URI(s);
                    if (tmpUri.getScheme() == null) {
                        throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                    }
                    this.metastoreUris[i++] = tmpUri;
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                MetaStoreUtils.logAndThrowMetaException(e);
            }
        } else if (conf.getVar(HiveConf.ConfVars.METASTOREDIRECTORY) != null) {
            this.metastoreUris = new URI[1];
            try {
                this.metastoreUris[0] = new URI(conf.getVar(HiveConf.ConfVars.METASTOREDIRECTORY));
            }
            catch (URISyntaxException e) {
                MetaStoreUtils.logAndThrowMetaException(e);
            }
        } else {
            LOG.error((Object)"NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.open();
    }

    @Override
    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws InvalidOperationException, MetaException, TException {
        this.client.alter_table(dbname, tbl_name, new_tbl);
    }

    private void open() throws MetaException {
        for (URI store : this.metastoreUris) {
            LOG.info((Object)("Trying to connect to metastore with URI " + store));
            try {
                this.openStore(store);
            }
            catch (MetaException e) {
                LOG.warn((Object)e.getStackTrace());
                LOG.warn((Object)("Unable to connect metastore with URI " + store));
            }
            if (this.open) break;
        }
        if (!this.open) {
            throw new MetaException("Could not connect to meta store using any of the URIs provided");
        }
        LOG.info((Object)"Connected to metastore.");
    }

    private void openStore(URI store) throws MetaException {
        this.open = false;
        this.transport = new TSocket(store.getHost(), store.getPort());
        ((TSocket)this.transport).setTimeout(20000);
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
        for (int i = 0; i < this.retries && !this.open; ++i) {
            try {
                this.transport.open();
                this.open = true;
                continue;
            }
            catch (TTransportException e) {
                LOG.warn((Object)"failed to connect to MetaStore, re-trying...");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        if (!this.open) {
            throw new MetaException("could not connect to meta store");
        }
    }

    @Override
    public void close() {
        this.open = false;
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        if (this.standAloneClient) {
            try {
                this.client.shutdown();
            }
            catch (TException e) {
                LOG.error((Object)"Unable to shutdown local metastore client");
                LOG.error((Object)e.getStackTrace());
            }
        }
    }

    @Override
    public void dropTable(String tableName, boolean deleteData) throws MetaException, NoSuchObjectException {
        try {
            this.dropTable("default", tableName, deleteData, false);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
        }
    }

    @Override
    public Partition add_partition(Partition new_part) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.client.add_partition(new_part);
    }

    @Override
    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.client.append_partition(db_name, table_name, part_vals);
    }

    @Override
    public boolean createDatabase(String name, String location_uri) throws AlreadyExistsException, MetaException, TException {
        return this.client.create_database(name, location_uri);
    }

    @Override
    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.create_table(tbl);
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    @Override
    public boolean dropDatabase(String name) throws MetaException, TException {
        return this.client.drop_database(name);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition(db_name, tbl_name, part_vals, deleteData);
    }

    public void dropTable(String dbname, String name) throws NoSuchObjectException, MetaException, TException {
        this.dropTable(dbname, name, true, true);
    }

    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUknownTab) throws MetaException, TException, NoSuchObjectException {
        block2: {
            try {
                this.client.drop_table(dbname, name, deleteData);
            }
            catch (NoSuchObjectException e) {
                if (ignoreUknownTab) break block2;
                throw e;
            }
        }
    }

    public boolean dropType(String type) throws MetaException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        return this.client.get_type_all(name);
    }

    public List<String> getDatabases() throws MetaException, TException {
        return this.client.get_databases();
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_partitions(db_name, tbl_name, max_parts);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_database(name);
    }

    @Override
    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws MetaException, TException {
        return this.client.get_partition(db_name, tbl_name, part_vals);
    }

    @Override
    public Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        return this.client.get_table(dbname, name);
    }

    public Type getType(String name) throws MetaException, TException {
        return this.client.get_type(name);
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.client.get_tables(dbname, tablePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    public List<String> getTables(String tablePattern) throws MetaException {
        String dbname = "default";
        return this.getTables(dbname, tablePattern);
    }

    @Override
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        try {
            this.client.get_table("default", tableName);
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    @Override
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable("default", tableName);
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        return this.client.get_partition_names(dbName, tblName, max);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition(dbName, tblName, newPart);
    }

    @Override
    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.client.get_fields(db, tableName);
    }

    @Override
    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.client.get_schema(db, tableName);
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }
}

