/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class Warehouse {
    private Path whRoot;
    private Configuration conf;
    String whRootString;
    public static final Log LOG;
    static BitSet charToEscape;
    static final Pattern pat;

    public Warehouse(Configuration conf) throws MetaException {
        this.conf = conf;
        this.whRootString = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREWAREHOUSE);
        if (StringUtils.isBlank((String)this.whRootString)) {
            throw new MetaException(HiveConf.ConfVars.METASTOREWAREHOUSE.varname + " is not set in the config or blank");
        }
    }

    public FileSystem getFs(Path f) throws MetaException {
        try {
            return f.getFileSystem(this.conf);
        }
        catch (IOException e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    public Path getDnsPath(Path path) throws MetaException {
        FileSystem fs = this.getFs(path);
        return new Path(fs.getUri().getScheme(), fs.getUri().getAuthority(), path.toUri().getPath());
    }

    private Path getWhRoot() throws MetaException {
        if (this.whRoot != null) {
            return this.whRoot;
        }
        this.whRoot = this.getDnsPath(new Path(this.whRootString));
        return this.whRoot;
    }

    public Path getDefaultDatabasePath(String dbName) throws MetaException {
        if (dbName.equalsIgnoreCase("default")) {
            return this.getWhRoot();
        }
        return new Path(this.getWhRoot(), dbName.toLowerCase() + ".db");
    }

    public Path getDefaultTablePath(String dbName, String tableName) throws MetaException {
        return new Path(this.getDefaultDatabasePath(dbName), tableName.toLowerCase());
    }

    public boolean mkdirs(Path f) throws MetaException {
        try {
            FileSystem fs = this.getFs(f);
            LOG.debug((Object)("Creating directory if it doesn't exist: " + f));
            return fs.mkdirs(f) || fs.getFileStatus(f).isDir();
        }
        catch (IOException e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return false;
        }
    }

    public boolean deleteDir(Path f, boolean recursive) throws MetaException {
        LOG.info((Object)("deleting  " + f));
        try {
            FileSystem fs = this.getFs(f);
            if (!fs.exists(f)) {
                return false;
            }
            Configuration dupConf = new Configuration(this.conf);
            FileSystem.setDefaultUri((Configuration)dupConf, (URI)fs.getUri());
            Trash trashTmp = new Trash(dupConf);
            if (trashTmp.moveToTrash(f)) {
                LOG.info((Object)("Moved to trash: " + f));
                return true;
            }
            if (fs.delete(f, true)) {
                LOG.info((Object)("Deleted the diretory " + f));
                return true;
            }
            if (fs.exists(f)) {
                throw new MetaException("Unable to delete directory: " + f);
            }
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            MetaStoreUtils.logAndThrowMetaException(e);
        }
        return false;
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    static String escapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (Warehouse.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String makePartName(Map<String, String> spec) throws MetaException {
        StringBuffer suffixBuf = new StringBuffer();
        for (Map.Entry<String, String> e : spec.entrySet()) {
            if (e.getValue() == null || e.getValue().length() == 0) {
                throw new MetaException("Partition spec is incorrect. " + spec);
            }
            suffixBuf.append(Warehouse.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(Warehouse.escapePathName(e.getValue()));
            suffixBuf.append("/");
        }
        return suffixBuf.toString();
    }

    public static LinkedHashMap<String, String> makeSpecFromName(String name) throws MetaException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        if (name == null || name.isEmpty()) {
            throw new MetaException("Partition name is invalid. " + name);
        }
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        Path currPath = new Path(name);
        do {
            String v;
            String k;
            String component;
            Matcher m;
            if ((m = pat.matcher(component = currPath.getName())).matches()) {
                k = Warehouse.unescapePathName(m.group(1));
                v = Warehouse.unescapePathName(m.group(2));
                if (partSpec.containsKey(k)) {
                    throw new MetaException("Partition name is invalid. Key " + k + " defined at two levels");
                }
            } else {
                throw new MetaException("Partition name is invalid. " + name);
            }
            String[] kv = new String[]{k, v};
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty());
        for (int i = kvs.size(); i > 0; --i) {
            partSpec.put(((String[])kvs.get(i - 1))[0], ((String[])kvs.get(i - 1))[1]);
        }
        return partSpec;
    }

    public Path getPartitionPath(String dbName, String tableName, LinkedHashMap<String, String> pm) throws MetaException {
        return new Path(this.getDefaultTablePath(dbName, tableName), Warehouse.makePartName(pm));
    }

    public Path getPartitionPath(Path tblPath, LinkedHashMap<String, String> pm) throws MetaException {
        return new Path(tblPath, Warehouse.makePartName(pm));
    }

    public boolean isDir(Path f) throws MetaException {
        try {
            FileSystem fs = this.getFs(f);
            FileStatus fstatus = fs.getFileStatus(f);
            if (!fstatus.isDir()) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            MetaStoreUtils.logAndThrowMetaException(e);
        }
        return true;
    }

    public static String makePartName(List<FieldSchema> partCols, List<String> vals) throws MetaException {
        if (partCols.size() != vals.size() || partCols.size() == 0) {
            throw new MetaException("Invalid partition key & values");
        }
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(Warehouse.escapePathName(partCols.get(i).getName().toLowerCase()));
            name.append('=');
            name.append(Warehouse.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static {
        char[] clist;
        LOG = LogFactory.getLog((String)"hive.metastore.warehouse");
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u00ff'}) {
            charToEscape.set(c);
        }
        pat = Pattern.compile("([^/]+)=([^/]+)");
    }
}

