/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Partition
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Partition");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 6);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 7);
    private List<String> values;
    public static final int VALUES = 1;
    private String dbName;
    public static final int DBNAME = 2;
    private String tableName;
    public static final int TABLENAME = 3;
    private int createTime;
    public static final int CREATETIME = 4;
    private int lastAccessTime;
    public static final int LASTACCESSTIME = 5;
    private StorageDescriptor sd;
    public static final int SD = 6;
    private Map<String, String> parameters;
    public static final int PARAMETERS = 7;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("values", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
            this.put(2, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
            this.put(3, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
            this.put(4, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
            this.put(5, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
            this.put(6, new FieldMetaData("sd", 3, (FieldValueMetaData)new StructMetaData(12, StorageDescriptor.class)));
            this.put(7, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        }
    });

    public Partition() {
    }

    public Partition(List<String> values, String dbName, String tableName, int createTime, int lastAccessTime, StorageDescriptor sd, Map<String, String> parameters) {
        this();
        this.values = values;
        this.dbName = dbName;
        this.tableName = tableName;
        this.createTime = createTime;
        this.__isset.createTime = true;
        this.lastAccessTime = lastAccessTime;
        this.__isset.lastAccessTime = true;
        this.sd = sd;
        this.parameters = parameters;
    }

    public Partition(Partition other) {
        if (other.isSetValues()) {
            ArrayList<String> __this__values = new ArrayList<String>();
            for (String string : other.values) {
                __this__values.add(string);
            }
            this.values = __this__values;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        this.__isset.createTime = other.__isset.createTime;
        this.createTime = other.createTime;
        this.__isset.lastAccessTime = other.__isset.lastAccessTime;
        this.lastAccessTime = other.lastAccessTime;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry entry : other.parameters.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
    }

    public Partition clone() {
        return new Partition(this);
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public Iterator<String> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(String elem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(elem);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.__isset.createTime = true;
    }

    public void unsetCreateTime() {
        this.__isset.createTime = false;
    }

    public boolean isSetCreateTime() {
        return this.__isset.createTime;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.__isset.lastAccessTime = true;
    }

    public void unsetLastAccessTime() {
        this.__isset.lastAccessTime = false;
    }

    public boolean isSetLastAccessTime() {
        return this.__isset.lastAccessTime;
    }

    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getValues();
            }
            case 2: {
                return this.getDbName();
            }
            case 3: {
                return this.getTableName();
            }
            case 4: {
                return new Integer(this.getCreateTime());
            }
            case 5: {
                return new Integer(this.getLastAccessTime());
            }
            case 6: {
                return this.getSd();
            }
            case 7: {
                return this.getParameters();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetValues();
            }
            case 2: {
                return this.isSetDbName();
            }
            case 3: {
                return this.isSetTableName();
            }
            case 4: {
                return this.isSetCreateTime();
            }
            case 5: {
                return this.isSetLastAccessTime();
            }
            case 6: {
                return this.isSetSd();
            }
            case 7: {
                return this.isSetParameters();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Partition) {
            return this.equals((Partition)that);
        }
        return false;
    }

    public boolean equals(Partition that) {
        if (that == null) {
            return false;
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!((Object)this.values).equals(that.values)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!((Object)this.parameters).equals(that.parameters)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list35 = iprot.readListBegin();
                        this.values = new ArrayList<String>(_list35.size);
                        for (int _i36 = 0; _i36 < _list35.size; ++_i36) {
                            String _elem37 = iprot.readString();
                            this.values.add(_elem37);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.dbName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.tableName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.createTime = iprot.readI32();
                        this.__isset.createTime = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.lastAccessTime = iprot.readI32();
                        this.__isset.lastAccessTime = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 12) {
                        this.sd = new StorageDescriptor();
                        this.sd.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 7: {
                    if (field.type == 13) {
                        TMap _map38 = iprot.readMapBegin();
                        this.parameters = new HashMap<String, String>(2 * _map38.size);
                        for (int _i39 = 0; _i39 < _map38.size; ++_i39) {
                            String _key40 = iprot.readString();
                            String _val41 = iprot.readString();
                            this.parameters.put(_key40, _val41);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.values != null) {
            oprot.writeFieldBegin(VALUES_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.values.size()));
            for (String string : this.values) {
                oprot.writeString(string);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.dbName != null) {
            oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
            oprot.writeString(this.dbName);
            oprot.writeFieldEnd();
        }
        if (this.tableName != null) {
            oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
            oprot.writeString(this.tableName);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
        oprot.writeI32(this.createTime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
        oprot.writeI32(this.lastAccessTime);
        oprot.writeFieldEnd();
        if (this.sd != null) {
            oprot.writeFieldBegin(SD_FIELD_DESC);
            this.sd.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.parameters != null) {
            oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.parameters.size()));
            for (Map.Entry entry : this.parameters.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition(");
        boolean first = true;
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(Partition.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean createTime = false;
        public boolean lastAccessTime = false;

        private Isset() {
        }
    }
}

