/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public class LazyPrimitiveObjectInspectorFactory {
    public static final LazyBooleanObjectInspector lazyBooleanObjectInspector = new LazyBooleanObjectInspector();
    public static final LazyByteObjectInspector lazyByteObjectInspector = new LazyByteObjectInspector();
    public static final LazyShortObjectInspector lazyShortObjectInspector = new LazyShortObjectInspector();
    public static final LazyIntObjectInspector lazyIntObjectInspector = new LazyIntObjectInspector();
    public static final LazyLongObjectInspector lazyLongObjectInspector = new LazyLongObjectInspector();
    public static final LazyFloatObjectInspector lazyFloatObjectInspector = new LazyFloatObjectInspector();
    public static final LazyDoubleObjectInspector lazyDoubleObjectInspector = new LazyDoubleObjectInspector();
    public static final LazyVoidObjectInspector lazyVoidObjectInspector = new LazyVoidObjectInspector();
    static HashMap<ArrayList<Object>, LazyStringObjectInspector> cachedLazyStringObjectInspector = new HashMap();

    public static LazyStringObjectInspector getLazyStringObjectInspector(boolean escaped, byte escapeChar) {
        ArrayList<Comparable<Boolean>> signature = new ArrayList<Comparable<Boolean>>();
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyStringObjectInspector result = cachedLazyStringObjectInspector.get(signature);
        if (result == null) {
            result = new LazyStringObjectInspector(escaped, escapeChar);
            cachedLazyStringObjectInspector.put(signature, result);
        }
        return result;
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, boolean escaped, byte escapeChar) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return lazyBooleanObjectInspector;
            }
            case BYTE: {
                return lazyByteObjectInspector;
            }
            case SHORT: {
                return lazyShortObjectInspector;
            }
            case INT: {
                return lazyIntObjectInspector;
            }
            case LONG: {
                return lazyLongObjectInspector;
            }
            case FLOAT: {
                return lazyFloatObjectInspector;
            }
            case DOUBLE: {
                return lazyDoubleObjectInspector;
            }
            case STRING: {
                return LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector(escaped, escapeChar);
            }
        }
        throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
    }
}

