/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.genericudf.example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;

@description(name="dboutput", value="_FUNC_(jdbcstring,username,password,preparedstatement,[arguments]) - sends data to a jdbc driver", extended="argument 0 is the JDBC connection string\nargument 1 is the user name\nargument 2 is the password\nargument 3 is an SQL query to be used in the PreparedStatement\nargument (4-n) The remaining arguments must be primitive and are passed to the PreparedStatement object\n")
@UDFType(deterministic=false)
public class GenericUDFDBOutput
extends GenericUDF {
    private static Log LOG = LogFactory.getLog((String)GenericUDFDBOutput.class.getName());
    ObjectInspector[] argumentOI;
    GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;
    Connection connection = null;
    private String url;
    private String user;
    private String pass;
    private IntWritable result = new IntWritable(-1);

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentTypeException {
        int i;
        this.argumentOI = arguments;
        for (i = 0; i < 4; ++i) {
            PrimitiveObjectInspector poi;
            if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE || (poi = (PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING) continue;
            throw new UDFArgumentTypeException(i, "The argument of function  should be \"string\", but \"" + arguments[i].getTypeName() + "\" is found");
        }
        for (i = 4; i < arguments.length; ++i) {
            if (arguments[i].getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The argument of function should be primative, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.url = ((StringObjectInspector)this.argumentOI[0]).getPrimitiveJavaObject(arguments[0].get());
        this.user = ((StringObjectInspector)this.argumentOI[1]).getPrimitiveJavaObject(arguments[1].get());
        this.pass = ((StringObjectInspector)this.argumentOI[2]).getPrimitiveJavaObject(arguments[2].get());
        try {
            this.connection = DriverManager.getConnection(this.url, this.user, this.pass);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Driver loading or connection issue", (Throwable)ex);
            this.result.set(2);
        }
        if (this.connection != null) {
            try {
                PreparedStatement ps = this.connection.prepareStatement(((StringObjectInspector)this.argumentOI[3]).getPrimitiveJavaObject(arguments[3].get()));
                for (int i = 4; i < arguments.length; ++i) {
                    PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.argumentOI[i];
                    ps.setObject(i - 3, poi.getPrimitiveJavaObject(arguments[i].get()));
                }
                ps.execute();
                ps.close();
                this.result.set(0);
            }
            catch (SQLException e) {
                LOG.error((Object)"Underlying SQL exception", (Throwable)e);
                this.result.set(1);
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Underlying SQL exception during close", (Throwable)ex);
                }
            }
        }
        return this.result;
    }

    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("dboutput(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(",");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

