/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.SignaturePattern;
import org.aspectj.weaver.patterns.TypePattern;

public class DeclareAnnotation
extends Declare {
    public static final Kind AT_TYPE = new Kind(1, "type");
    public static final Kind AT_FIELD = new Kind(2, "field");
    public static final Kind AT_METHOD = new Kind(3, "method");
    public static final Kind AT_CONSTRUCTOR = new Kind(4, "constructor");
    private Kind kind;
    private TypePattern typePattern;
    private SignaturePattern sigPattern;
    private String annotationMethod = "unknown";
    private String annotationString = "@<annotation>";
    private ResolvedType containingAspect;
    private AnnotationAJ annotation;

    public DeclareAnnotation(Kind kind, TypePattern typePattern) {
        this.typePattern = typePattern;
        this.kind = kind;
    }

    public String getAnnotationString() {
        return this.annotationString;
    }

    public DeclareAnnotation(Kind kind, SignaturePattern sigPattern) {
        this.sigPattern = sigPattern;
        this.kind = kind;
    }

    public boolean isExactPattern() {
        return this.typePattern instanceof ExactTypePattern;
    }

    public String getAnnotationMethod() {
        return this.annotationMethod;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("declare @");
        ret.append(this.kind);
        ret.append(" : ");
        ret.append(this.typePattern != null ? this.typePattern.toString() : this.sigPattern.toString());
        ret.append(" : ");
        ret.append(this.annotationString);
        return ret.toString();
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void resolve(IScope scope) {
        if (!scope.getWorld().isInJava5Mode()) {
            String msg = null;
            if (this.kind == AT_TYPE) {
                msg = "declareAtTypeNeedsJava5";
            } else if (this.kind == AT_METHOD) {
                msg = "declareAtMethodNeedsJava5";
            } else if (this.kind == AT_FIELD) {
                msg = "declareAtFieldNeedsJava5";
            } else if (this.kind == AT_CONSTRUCTOR) {
                msg = "declareAtConsNeedsJava5";
            }
            scope.message(MessageUtil.error(WeaverMessages.format(msg), this.getSourceLocation()));
            return;
        }
        if (this.typePattern != null) {
            this.typePattern = this.typePattern.resolveBindings(scope, Bindings.NONE, false, false);
        }
        if (this.sigPattern != null) {
            this.sigPattern = this.sigPattern.resolveBindings(scope, Bindings.NONE);
        }
        this.containingAspect = scope.getEnclosingType();
    }

    public Declare parameterizeWith(Map typeVariableBindingMap, World w) {
        DeclareAnnotation ret = this.kind == AT_TYPE ? new DeclareAnnotation(this.kind, this.typePattern.parameterizeWith(typeVariableBindingMap, w)) : new DeclareAnnotation(this.kind, this.sigPattern.parameterizeWith(typeVariableBindingMap, w));
        ret.annotationMethod = this.annotationMethod;
        ret.annotationString = this.annotationString;
        ret.containingAspect = this.containingAspect;
        ret.annotation = this.annotation;
        ret.copyLocationFrom(this);
        return ret;
    }

    public boolean isAdviceLike() {
        return false;
    }

    public void setAnnotationString(String as) {
        this.annotationString = as;
    }

    public void setAnnotationMethod(String methName) {
        this.annotationMethod = methName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeclareAnnotation)) {
            return false;
        }
        DeclareAnnotation other = (DeclareAnnotation)obj;
        if (!this.kind.equals(other.kind)) {
            return false;
        }
        if (!this.annotationString.equals(other.annotationString)) {
            return false;
        }
        if (!this.annotationMethod.equals(other.annotationMethod)) {
            return false;
        }
        if (this.typePattern != null && !this.typePattern.equals(other.typePattern)) {
            return false;
        }
        return this.sigPattern == null || this.sigPattern.equals(other.sigPattern);
    }

    public int hashCode() {
        int result = 19;
        result = 37 * result + this.kind.hashCode();
        result = 37 * result + this.annotationString.hashCode();
        result = 37 * result + this.annotationMethod.hashCode();
        if (this.typePattern != null) {
            result = 37 * result + this.typePattern.hashCode();
        }
        if (this.sigPattern != null) {
            result = 37 * result + this.sigPattern.hashCode();
        }
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(5);
        s.writeInt(this.kind.id);
        s.writeUTF(this.annotationString);
        s.writeUTF(this.annotationMethod);
        if (this.typePattern != null) {
            this.typePattern.write(s);
        }
        if (this.sigPattern != null) {
            this.sigPattern.write(s);
        }
        this.writeLocation(s);
    }

    public static Declare read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        DeclareAnnotation ret = null;
        int kind = s.readInt();
        String annotationString = s.readUTF();
        String annotationMethod = s.readUTF();
        TypePattern tp = null;
        SignaturePattern sp = null;
        switch (kind) {
            case 1: {
                tp = TypePattern.read(s, context);
                ret = new DeclareAnnotation(AT_TYPE, tp);
                break;
            }
            case 2: {
                sp = SignaturePattern.read(s, context);
                ret = new DeclareAnnotation(AT_FIELD, sp);
                break;
            }
            case 3: {
                sp = SignaturePattern.read(s, context);
                ret = new DeclareAnnotation(AT_METHOD, sp);
                break;
            }
            case 4: {
                sp = SignaturePattern.read(s, context);
                ret = new DeclareAnnotation(AT_CONSTRUCTOR, sp);
            }
        }
        ret.setAnnotationString(annotationString);
        ret.setAnnotationMethod(annotationMethod);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean matches(ResolvedMember rm, World world) {
        return this.sigPattern.matches(rm, world, false);
    }

    public boolean matches(ResolvedType typeX) {
        if (!this.typePattern.matchesStatically(typeX)) {
            return false;
        }
        if (typeX.getWorld().getLint().typeNotExposedToWeaver.isEnabled() && !typeX.isExposedToWeaver()) {
            typeX.getWorld().getLint().typeNotExposedToWeaver.signal(typeX.getName(), this.getSourceLocation());
        }
        return true;
    }

    public void setAspect(ResolvedType typeX) {
        this.containingAspect = typeX;
    }

    public UnresolvedType getAspect() {
        return this.containingAspect;
    }

    public void copyAnnotationTo(ResolvedType onType) {
        this.ensureAnnotationDiscovered();
        if (!onType.hasAnnotation(this.annotation.getType())) {
            onType.addAnnotation(this.annotation);
        }
    }

    public AnnotationAJ getAnnotationX() {
        this.ensureAnnotationDiscovered();
        return this.annotation;
    }

    private void ensureAnnotationDiscovered() {
        if (this.annotation != null) {
            return;
        }
        Iterator iter = this.containingAspect.getMethods();
        while (iter.hasNext()) {
            ResolvedMember member = (ResolvedMember)iter.next();
            if (!member.getName().equals(this.annotationMethod)) continue;
            AnnotationAJ[] annos = member.getAnnotations();
            if (annos == null) {
                return;
            }
            this.annotation = annos[0];
        }
    }

    public TypePattern getTypePattern() {
        return this.typePattern;
    }

    public SignaturePattern getSignaturePattern() {
        return this.sigPattern;
    }

    public boolean isStarredAnnotationPattern() {
        if (this.typePattern != null) {
            return this.typePattern.isStarAnnotation();
        }
        if (this.sigPattern != null) {
            return this.sigPattern.isStarAnnotation();
        }
        throw new RuntimeException("Impossible! what kind of deca is this: " + this);
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isDeclareAtConstuctor() {
        return this.kind.equals(AT_CONSTRUCTOR);
    }

    public boolean isDeclareAtMethod() {
        return this.kind.equals(AT_METHOD);
    }

    public boolean isDeclareAtType() {
        return this.kind.equals(AT_TYPE);
    }

    public boolean isDeclareAtField() {
        return this.kind.equals(AT_FIELD);
    }

    public UnresolvedType getAnnotationTypeX() {
        this.ensureAnnotationDiscovered();
        return this.annotation == null ? null : this.annotation.getType();
    }

    public boolean isAnnotationAllowedOnField() {
        this.ensureAnnotationDiscovered();
        return this.annotation.allowedOnField();
    }

    public String getPatternAsString() {
        if (this.sigPattern != null) {
            return this.sigPattern.toString();
        }
        if (this.typePattern != null) {
            return this.typePattern.toString();
        }
        return "DONT KNOW";
    }

    public boolean couldEverMatch(ResolvedType type) {
        if (this.sigPattern != null) {
            return this.sigPattern.getDeclaringType().matches(type, TypePattern.STATIC).maybeTrue();
        }
        return true;
    }

    public String getNameSuffix() {
        return this.getKind().toString();
    }

    public static class Kind {
        private final int id;
        private String s;

        private Kind(int n, String name) {
            this.id = n;
            this.s = name;
        }

        public int hashCode() {
            return 19 + 37 * this.id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Kind)) {
                return false;
            }
            Kind other = (Kind)obj;
            return other.id == this.id;
        }

        public String toString() {
            return "at_" + this.s;
        }
    }
}

