/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.XMLLoaderBufferedPositionedInputStream;
import org.apache.tools.bzip2r.CBZip2InputStream;

public class XMLLoader
extends LoadFunc {
    protected final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private XMLFileRecordReader reader = null;
    private ArrayList<Object> mProtoTuple = null;
    public String recordIdentifier = "document";
    private String loadLocation;

    public XMLLoader() {
    }

    public XMLLoader(String recordIdentifier) {
        this();
        this.recordIdentifier = recordIdentifier;
    }

    public Tuple getNext() throws IOException {
        boolean next = false;
        try {
            next = this.reader.nextKeyValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (!next) {
            return null;
        }
        Tuple t = null;
        try {
            byte[] tagContent = (byte[])this.reader.getCurrentValue();
            t = tagContent.length > 0 ? this.createTuple(tagContent) : null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return t;
    }

    public Tuple createTuple(byte[] content) throws Exception {
        if (this.mProtoTuple == null) {
            this.mProtoTuple = new ArrayList();
        }
        if (content.length > 0) {
            this.mProtoTuple.add(new DataByteArray(content));
        }
        Tuple t = TupleFactory.getInstance().newTupleNoCopy(this.mProtoTuple);
        this.mProtoTuple = null;
        return t;
    }

    public boolean equals(Object obj) {
        return this.equals((XMLLoader)((Object)obj));
    }

    public boolean equals(XMLLoader other) {
        return this.recordIdentifier.equals(other.recordIdentifier);
    }

    public InputFormat getInputFormat() throws IOException {
        XMLFileInputFormat inputFormat = new XMLFileInputFormat(this.recordIdentifier);
        if (this.loadLocation.endsWith(".bz2") || this.loadLocation.endsWith(".bz")) {
            inputFormat.isSplitable = true;
        }
        return inputFormat;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = (XMLFileRecordReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        this.loadLocation = location;
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public static class XMLFileRecordReader
    extends RecordReader {
        private long start;
        private long end;
        private String recordIdentifier;
        private XMLLoaderBufferedPositionedInputStream xmlLoaderBPIS = null;

        public XMLFileRecordReader(String recordIdentifier) {
            this.recordIdentifier = recordIdentifier;
        }

        public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            FileSplit split = (FileSplit)genericSplit;
            Configuration job = context.getConfiguration();
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem(job);
            FSDataInputStream fileIn = fs.open(split.getPath());
            fileIn.seek(this.start);
            if (file.toString().endsWith(".bz2") || file.toString().endsWith(".bz")) {
                CBZip2InputStream in = new CBZip2InputStream(fileIn, 9, this.end);
                this.xmlLoaderBPIS = new XMLLoaderBufferedPositionedInputStream((InputStream)in, this.start, this.end);
            } else if (file.toString().endsWith(".gz")) {
                CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(job);
                CompressionCodec codec = compressionCodecs.getCodec(file);
                if (codec != null) {
                    this.end = Long.MAX_VALUE;
                    CompressionInputStream stream = codec.createInputStream((InputStream)fileIn);
                    this.xmlLoaderBPIS = new XMLLoaderBufferedPositionedInputStream((InputStream)stream, this.start, this.end);
                }
            } else {
                this.xmlLoaderBPIS = new XMLLoaderBufferedPositionedInputStream((InputStream)fileIn, this.start, this.end);
            }
        }

        public void close() throws IOException {
            this.xmlLoaderBPIS.close();
        }

        public Object getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public Object getCurrentValue() throws IOException, InterruptedException {
            return this.xmlLoaderBPIS.collectTag(this.recordIdentifier, this.end);
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.xmlLoaderBPIS.isReadable();
        }
    }

    public static class XMLFileInputFormat
    extends FileInputFormat {
        private boolean isSplitable = false;
        private String recordIdentifier;

        public XMLFileInputFormat(String recordIdentifier) {
            this.recordIdentifier = recordIdentifier;
        }

        public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new XMLFileRecordReader(this.recordIdentifier);
        }

        protected boolean isSplitable(JobContext context, Path filename) {
            CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(filename);
            return codec != null ? this.isSplitable : true;
        }
    }
}

