/*
 * Decompiled with CFR 0.152.
 */
package py4j.model;

import java.util.regex.Pattern;
import py4j.model.Py4JClass;
import py4j.model.Py4JField;
import py4j.model.Py4JMember;
import py4j.model.Py4JMethod;
import py4j.reflection.TypeUtil;

public class HelpPageGenerator {
    public static final String PREFIX = "|";
    public static final String INDENT = "  ";
    public static final String PREFIX_INDENT = "|  ";
    public static final String DOUBLE_LINES = "\n|  \n";
    public static final String SEPARATOR = "------------------------------------------------------------";
    public static final String PREFIX_SEPARATOR = "|  ------------------------------------------------------------\n";

    public static final String getHelpPage(Py4JClass clazz, String pattern, boolean shortName) {
        String signature;
        Pattern regex = HelpPageGenerator.getRegex(pattern);
        StringBuilder builder = new StringBuilder();
        builder.append("Help on ");
        builder.append("class ");
        builder.append(TypeUtil.getName(clazz.getName(), true));
        builder.append(" in package ");
        builder.append(TypeUtil.getPackage(clazz.getName()));
        builder.append(":\n\n");
        builder.append(clazz.getSignature(shortName));
        builder.append(" {");
        builder.append(DOUBLE_LINES);
        builder.append(PREFIX_INDENT);
        builder.append("Methods defined here:");
        builder.append(DOUBLE_LINES);
        for (Py4JMethod py4JMethod : clazz.getMethods()) {
            signature = py4JMethod.getSignature(shortName);
            if (!regex.matcher(signature).matches()) continue;
            builder.append(PREFIX_INDENT);
            builder.append(signature);
            builder.append(DOUBLE_LINES);
        }
        builder.append(PREFIX_SEPARATOR);
        builder.append(PREFIX_INDENT);
        builder.append("Fields defined here:");
        builder.append(DOUBLE_LINES);
        for (Py4JMember py4JMember : clazz.getFields()) {
            signature = ((Py4JField)py4JMember).getSignature(shortName);
            if (!regex.matcher(signature).matches()) continue;
            builder.append(PREFIX_INDENT);
            builder.append(signature);
            builder.append(DOUBLE_LINES);
        }
        builder.append(PREFIX_SEPARATOR);
        builder.append(PREFIX_INDENT);
        builder.append("Internal classes defined here:");
        builder.append(DOUBLE_LINES);
        for (Py4JMember py4JMember : clazz.getClasses()) {
            builder.append(PREFIX_INDENT);
            builder.append(((Py4JClass)py4JMember).getSignature(shortName));
            builder.append(DOUBLE_LINES);
        }
        builder.append("}");
        builder.append("\n");
        return builder.toString();
    }

    public static final String getHelpPage(Py4JMethod method, boolean shortName) {
        StringBuilder builder = new StringBuilder();
        builder.append("Method \"");
        builder.append(method.getName());
        builder.append("\" of class ");
        builder.append(method.getContainer());
        builder.append("\n{\n");
        builder.append(PREFIX_INDENT);
        builder.append(method.getSignature(shortName));
        builder.append("\n}");
        builder.append("\n");
        return builder.toString();
    }

    public static final Pattern getRegex(String pattern) {
        if (pattern == null) {
            return Pattern.compile(".*");
        }
        String newPattern = "^" + pattern.trim().replace(".", "\\.").replace("*", ".*").replace("?", ".?").replace("(", "\\(").replace(")", "\\)");
        return Pattern.compile(newPattern);
    }
}

