/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.persistence.DCLLItem;
import org.apache.hadoop.hive.ql.exec.persistence.MRU;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.jdbm.RecordManager;
import org.apache.hadoop.hive.ql.util.jdbm.RecordManagerFactory;
import org.apache.hadoop.hive.ql.util.jdbm.helper.FastIterator;
import org.apache.hadoop.hive.ql.util.jdbm.htree.HTree;

public class HashMapWrapper<K, V> {
    protected Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private static final int THRESHOLD = 25000;
    private int threshold;
    private HashMap<K, MRUItem> mHash;
    private HTree pHash;
    private RecordManager recman;
    private File tmpFile;
    private MRU<MRUItem> MRUList;

    public HashMapWrapper(int threshold) {
        this.threshold = threshold;
        this.pHash = null;
        this.recman = null;
        this.tmpFile = null;
        this.mHash = new HashMap();
        this.MRUList = new MRU();
    }

    public HashMapWrapper() {
        this(25000);
    }

    public V get(K key) throws HiveException {
        Object value = null;
        MRUItem item = this.mHash.get(key);
        if (item != null) {
            value = item.value;
            this.MRUList.moveToHead(item);
        } else if (this.pHash != null) {
            try {
                value = this.pHash.get(key);
                if (value != null) {
                    if (this.mHash.size() < this.threshold) {
                        this.mHash.put(key, new MRUItem(key, value));
                        this.pHash.remove(key);
                    } else if (this.threshold > 0) {
                        MRUItem tail = this.MRUList.tail();
                        this.pHash.put(tail.key, tail.value);
                        this.pHash.remove(key);
                        this.recman.commit();
                        item = this.mHash.remove(tail.key);
                        item.key = key;
                        item.value = value;
                        this.mHash.put(key, item);
                        tail.key = key;
                        tail.value = value;
                        this.MRUList.moveToHead(tail);
                    }
                }
            }
            catch (Exception e) {
                this.LOG.warn((Object)e.toString());
                throw new HiveException(e);
            }
        }
        return (V)value;
    }

    public void put(K key, V value) throws HiveException {
        int mm_size = this.mHash.size();
        MRUItem itm = this.mHash.get(key);
        if (mm_size < this.threshold) {
            if (itm != null) {
                itm.value = value;
                this.MRUList.moveToHead(itm);
                if (!this.mHash.get(key).value.equals(value)) {
                    this.LOG.error((Object)"HashMapWrapper.put() reuse MRUItem inconsistency [1].");
                }
                assert (this.mHash.get(key).value.equals(value));
            } else {
                try {
                    if (this.pHash != null && this.pHash.get(key) != null) {
                        this.pHash.remove(key);
                        this.pHash.put(key, value);
                        this.recman.commit();
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                itm = new MRUItem(key, value);
                this.MRUList.put(itm);
                this.mHash.put(key, itm);
            }
        } else if (itm != null) {
            itm.value = value;
            this.MRUList.moveToHead(itm);
            if (!this.mHash.get(key).value.equals(value)) {
                this.LOG.error((Object)"HashMapWrapper.put() reuse MRUItem inconsistency [2].");
            }
            assert (this.mHash.get(key).value.equals(value));
        } else {
            if (this.pHash == null) {
                this.pHash = this.getPersistentHash();
            }
            try {
                this.pHash.put(key, value);
                this.recman.commit();
            }
            catch (Exception e) {
                this.LOG.warn((Object)e.toString());
                throw new HiveException(e);
            }
        }
    }

    private HTree getPersistentHash() throws HiveException {
        try {
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            this.tmpFile = File.createTempFile("HashMapWrapper", ".tmp", new File("/tmp"));
            this.LOG.info((Object)("HashMapWrapper created temp file " + this.tmpFile.getAbsolutePath()));
            this.tmpFile.deleteOnExit();
            Properties props = new Properties();
            props.setProperty("jdbm.cache.type", "nocache");
            props.setProperty("jdbm.disableTransactions", "true");
            this.recman = RecordManagerFactory.createRecordManager(this.tmpFile, props);
            this.pHash = HTree.createInstance(this.recman);
        }
        catch (Exception e) {
            this.LOG.warn((Object)e.toString());
            throw new HiveException(e);
        }
        return this.pHash;
    }

    public void clear() throws HiveException {
        if (this.mHash != null) {
            this.mHash.clear();
            this.MRUList.clear();
        }
        this.close();
    }

    public void remove(Object key) throws HiveException {
        MRUItem entry = this.mHash.remove(key);
        if (entry != null) {
            this.MRUList.remove(entry);
        } else if (this.pHash != null) {
            try {
                this.pHash.remove(key);
            }
            catch (Exception e) {
                this.LOG.warn((Object)e.toString());
                throw new HiveException(e);
            }
        }
    }

    public Set<K> keySet() {
        HashSet<Object> ret = null;
        if (this.mHash != null) {
            ret = new HashSet<Object>();
            ret.addAll(this.mHash.keySet());
        }
        if (this.pHash != null) {
            try {
                FastIterator fitr = this.pHash.keys();
                if (fitr != null) {
                    Object k;
                    while ((k = fitr.next()) != null) {
                        ret.add(k);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public int cacheSize() {
        return this.threshold;
    }

    public void close() throws HiveException {
        if (this.pHash != null) {
            try {
                if (this.recman != null) {
                    this.recman.close();
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            this.tmpFile.delete();
            this.tmpFile = null;
            this.pHash = null;
            this.recman = null;
        }
    }

    class MRUItem
    extends DCLLItem {
        K key;
        V value;

        MRUItem(K k, V v) {
            this.key = k;
            this.value = v;
        }
    }
}

