/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.alterTableDesc;
import org.apache.hadoop.hive.ql.plan.descFunctionDesc;
import org.apache.hadoop.hive.ql.plan.descTableDesc;
import org.apache.hadoop.hive.ql.plan.dropTableDesc;
import org.apache.hadoop.hive.ql.plan.fetchWork;
import org.apache.hadoop.hive.ql.plan.showFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.showPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.showTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.showTablesDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.DDLSemanticAnalyzer");
    public static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();

    public static String getTypeName(int token) throws SemanticException {
        if (token == 72 || token == 73 || token == 74) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        return TokenToTypeName.get(token);
    }

    public DDLSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getToken().getType() == 99) {
            this.analyzeDropTable(ast);
        } else if (ast.getToken().getType() == 81) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeDescribeTable(ast);
        } else if (ast.getToken().getType() == 95) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowTables(ast);
        } else if (ast.getToken().getType() == 98) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowTableStatus(ast);
        } else if (ast.getToken().getType() == 96) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowFunctions(ast);
        } else if (ast.getToken().getType() == 82) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeDescFunction(ast);
        } else if (ast.getToken().getType() == 94) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeMetastoreCheck(ast);
        } else if (ast.getToken().getType() == 83) {
            this.analyzeAlterTableRename(ast);
        } else if (ast.getToken().getType() == 84) {
            this.analyzeAlterTableModifyCols(ast, alterTableDesc.alterTableTypes.ADDCOLS);
        } else if (ast.getToken().getType() == 86) {
            this.analyzeAlterTableModifyCols(ast, alterTableDesc.alterTableTypes.REPLACECOLS);
        } else if (ast.getToken().getType() == 85) {
            this.analyzeAlterTableRenameCol(ast);
        } else if (ast.getToken().getType() == 87) {
            this.analyzeAlterTableAddParts(ast);
        } else if (ast.getToken().getType() == 88) {
            this.analyzeAlterTableDropParts(ast);
        } else if (ast.getToken().getType() == 92) {
            this.analyzeAlterTableProps(ast);
        } else if (ast.getToken().getType() == 89) {
            this.analyzeAlterTableSerdeProps(ast);
        } else if (ast.getToken().getType() == 90) {
            this.analyzeAlterTableSerde(ast);
        } else if (ast.getToken().getType() == 91) {
            this.analyzeAlterTableFileFormat(ast);
        } else if (ast.getToken().getType() == 114) {
            this.analyzeAlterTableClusterSort(ast);
        } else if (ast.getToken().getType() == 97) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowPartitions(ast);
        } else {
            throw new SemanticException("Unsupported command.");
        }
    }

    private void analyzeDropTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        dropTableDesc dropTblDesc = new dropTableDesc(tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableProps(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> mapProp = this.getProps((ASTNode)ast.getChild(1).getChild(0));
        alterTableDesc alterTblDesc = new alterTableDesc(alterTableDesc.alterTableTypes.ADDPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> mapProp = this.getProps((ASTNode)ast.getChild(1).getChild(0));
        alterTableDesc alterTblDesc = new alterTableDesc(alterTableDesc.alterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerde(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        alterTableDesc alterTblDesc = new alterTableDesc(alterTableDesc.alterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 2) {
            HashMap<String, String> mapProp = this.getProps((ASTNode)ast.getChild(2).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String inputFormat = null;
        String outputFormat = null;
        String serde = null;
        ASTNode child = (ASTNode)ast.getChild(1);
        switch (child.getToken().getType()) {
            case 113: {
                inputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(0)).getToken().getText());
                outputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(inputFormat);
                    Class.forName(outputFormat);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 110: {
                inputFormat = SEQUENCEFILE_INPUT;
                outputFormat = SEQUENCEFILE_OUTPUT;
                break;
            }
            case 111: {
                inputFormat = TEXTFILE_INPUT;
                outputFormat = TEXTFILE_OUTPUT;
                break;
            }
            case 112: {
                inputFormat = RCFILE_INPUT;
                outputFormat = RCFILE_OUTPUT;
                serde = COLUMNAR_SERDE;
            }
        }
        alterTableDesc alterTblDesc = new alterTableDesc(tableName, inputFormat, outputFormat, serde);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableClusterSort(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        ASTNode buckets = (ASTNode)ast.getChild(1);
        List<String> bucketCols = this.getColumnNames((ASTNode)buckets.getChild(0));
        List<Order> sortCols = null;
        int numBuckets = -1;
        if (buckets.getChildCount() == 2) {
            numBuckets = Integer.valueOf(buckets.getChild(1).getText());
        } else {
            sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
            numBuckets = Integer.valueOf(buckets.getChild(2).getText());
        }
        if (numBuckets <= 0) {
            throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
        }
        alterTableDesc alterTblDesc = new alterTableDesc(tableName, numBuckets, bucketCols, sortCols);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private HashMap<String, String> getProps(ASTNode prop) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
            String key = DDLSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
            String value = DDLSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
            mapProp.put(key, value);
        }
        return mapProp;
    }

    private String getFullyQualifiedName(ASTNode ast) {
        if (ast.getChildCount() == 0) {
            return ast.getText();
        }
        return this.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + this.getFullyQualifiedName((ASTNode)ast.getChild(1));
    }

    private Task<? extends Serializable> createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", "9");
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        fetchWork fetch = new fetchWork(this.ctx.getResFile().toString(), new tableDesc(LazySimpleSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String tableName = this.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
        HashMap<String, String> partSpec = null;
        if (tableTypeExpr.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
            partSpec = this.getPartSpec(partspec);
        }
        boolean isExt = ast.getChildCount() > 1;
        descTableDesc descTblDesc = new descTableDesc(this.ctx.getResFile(), tableName, partSpec, isExt);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descTblDesc.getSchema()));
        LOG.info((Object)"analyzeDescribeTable done");
    }

    private HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        showPartitionsDesc showPartsDesc = new showPartitionsDesc(tableName, this.ctx.getResFile());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        showTablesDesc showTblsDesc;
        if (ast.getChildCount() == 1) {
            String tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showTblsDesc = new showTablesDesc(this.ctx.getResFile(), tableNames);
        } else {
            showTblsDesc = new showTablesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String dbName = "default";
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 160) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 11) {
                    partSpec = this.getPartSpec(child);
                    continue;
                }
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
        }
        showTableStatusDesc showTblStatusDesc = new showTableStatusDesc(this.ctx.getResFile(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        showFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new showFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else {
            showFuncsDesc = new showFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        descFunctionDesc descFuncDesc = new descFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(ASTNode ast) throws SemanticException {
        alterTableDesc alterTblDesc = new alterTableDesc(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()), DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenameCol(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String newComment = null;
        String newType = null;
        newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(3));
        boolean first = false;
        String flagCol = null;
        ASTNode positionNode = null;
        if (ast.getChildCount() == 6) {
            newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            positionNode = (ASTNode)ast.getChild(5);
        } else if (ast.getChildCount() == 5) {
            if (ast.getChild(4).getType() == 151) {
                newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            } else {
                positionNode = (ASTNode)ast.getChild(4);
            }
        }
        if (positionNode != null) {
            if (positionNode.getChildCount() == 0) {
                first = true;
            } else {
                flagCol = DDLSemanticAnalyzer.unescapeIdentifier(positionNode.getChild(0).getText());
            }
        }
        alterTableDesc alterTblDesc = new alterTableDesc(tblName, DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()), DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(2).getText()), newType, newComment, first, flagCol);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableModifyCols(ASTNode ast, alterTableDesc.alterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(1));
        alterTableDesc alterTblDesc = new alterTableDesc(tblName, newCols, alterType);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableDropParts(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        dropTableDesc dropTblDesc = new dropTableDesc(tblName, partSpecs);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAddParts(CommonTree ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        Iterator<Map<String, String>> partIter = partSpecs.iterator();
        String currentLocation = null;
        Map<String, String> currentPart = null;
        boolean ifNotExists = false;
        int numCh = ast.getChildCount();
        block5: for (int num = 1; num < numCh; ++num) {
            CommonTree child = (CommonTree)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 132: {
                    ifNotExists = true;
                    continue block5;
                }
                case 11: {
                    if (currentPart != null) {
                        AddPartitionDesc addPartitionDesc = new AddPartitionDesc("default", tblName, currentPart, currentLocation, ifNotExists);
                        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
                    }
                    currentLocation = null;
                    currentPart = partIter.next();
                    continue block5;
                }
                case 117: {
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block5;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            AddPartitionDesc addPartitionDesc = new AddPartitionDesc("default", tblName, currentPart, currentLocation, ifNotExists);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
        }
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 203;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
            }
        }
        List<Map<String, String>> specs = this.getPartitionSpecs(ast);
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc), this.conf, new Task[0]));
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 1; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partspec = ast.getChild(childIndex);
            if (partspec.getType() != 11) continue;
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            for (int i = 0; i < partspec.getChildCount(); ++i) {
                CommonTree partspec_val = (CommonTree)partspec.getChild(i);
                String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
            }
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    static {
        TokenToTypeName.put(69, "boolean");
        TokenToTypeName.put(65, "tinyint");
        TokenToTypeName.put(66, "smallint");
        TokenToTypeName.put(67, "int");
        TokenToTypeName.put(68, "bigint");
        TokenToTypeName.put(70, "float");
        TokenToTypeName.put(71, "double");
        TokenToTypeName.put(75, "string");
        TokenToTypeName.put(72, "date");
        TokenToTypeName.put(73, "datetime");
        TokenToTypeName.put(74, "timestamp");
    }
}

