/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;

@description(name="regexp_extract", value="_FUNC_(str, regexp[, idx]) - extracts a group that matches regexp", extended="Example:\n  > SELECT _FUNC_('100-200', '(\\d+)-(\\d+)', 1) FROM src LIMIT 1;\n  '100'")
public class UDFRegExpExtract
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFRegExpExtract.class.getName());
    private String lastRegex = null;
    private Pattern p = null;

    public String evaluate(String s, String regex, Integer extractIndex) {
        Matcher m;
        if (s == null || regex == null) {
            return null;
        }
        if (!regex.equals(this.lastRegex) || this.p == null) {
            this.lastRegex = regex;
            this.p = Pattern.compile(regex);
        }
        if ((m = this.p.matcher(s)).find()) {
            MatchResult mr = m.toMatchResult();
            return mr.group(extractIndex);
        }
        return "";
    }

    public String evaluate(String s, String regex) {
        return this.evaluate(s, regex, 1);
    }
}

