/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.expression.BooleanBitColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.ByteLiteral;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.ClassExpression;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlDateLiteral;
import org.datanucleus.store.mapped.expression.SqlTimeLiteral;
import org.datanucleus.store.mapped.expression.SqlTimestampLiteral;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.BigDecimalMapping;
import org.datanucleus.store.mapped.mapping.BigIntegerMapping;
import org.datanucleus.store.mapped.mapping.BooleanMapping;
import org.datanucleus.store.mapped.mapping.ByteMapping;
import org.datanucleus.store.mapped.mapping.CharacterMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorMapping;
import org.datanucleus.store.mapped.mapping.DoubleMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.FloatMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.ObjectIdClassMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.ShortMapping;
import org.datanucleus.store.mapped.mapping.SqlDateMapping;
import org.datanucleus.store.mapped.mapping.SqlTimeMapping;
import org.datanucleus.store.mapped.mapping.SqlTimestampMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.util.NucleusLogger;

public class ObjectExpression
extends ScalarExpression {
    protected ScalarExpression conditionExpr;
    private Class castType;
    private String fieldName;
    private String fieldType;
    private boolean usingRelatedTable = true;

    protected ObjectExpression(QueryExpression qs) {
        super(qs);
    }

    public ObjectExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public ObjectExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, JavaTypeMapping refMapping, LogicSetExpression teTarget, JavaTypeMapping selectMapping) {
        this(qs);
        ScalarExpression sourceExpr = mapping.getDatastoreContainer().getIDMapping().newScalarExpression(qs, te);
        ScalarExpression targetExpr = refMapping.newScalarExpression(qs, teTarget);
        qs.leftOuterJoin(sourceExpr, targetExpr, teTarget, true, true);
        this.mapping = selectMapping;
        this.te = teTarget;
        for (int i = 0; i < this.mapping.getNumberOfDatastoreFields(); ++i) {
            this.expressionList.addExpression(new ScalarExpression.DatastoreFieldExpression(qs, this.mapping.getDataStoreMapping(i).getDatastoreField(), teTarget));
        }
        this.st.append(this.expressionList.toString());
        this.usingRelatedTable = true;
    }

    public ObjectExpression(QueryExpression qs, ScalarExpression expr, ScalarExpression conditionExpr, LogicSetExpression te) {
        super(qs);
        this.te = te;
        this.mapping = expr.mapping;
        this.st.append(expr.st.toString());
        this.expressionList = expr.expressionList;
        this.conditionExpr = conditionExpr;
    }

    void useFirstDatastoreFieldOnly() {
        if (this.mapping.getNumberOfDatastoreFields() <= 1) {
            return;
        }
        this.expressionList = new ScalarExpression.ExpressionList(this);
        this.expressionList.addExpression(new ScalarExpression.DatastoreFieldExpression(this.qs, this.mapping.getDataStoreMapping(0).getDatastoreField(), this.te));
        this.st.clearStatement();
        this.st.append(this.expressionList.toString());
    }

    public void useIdentityFormOfPCMapping() {
        if (this.mapping instanceof PersistenceCapableMapping) {
            this.mapping = new ObjectIdClassMapping((PersistenceCapableMapping)this.mapping);
        }
    }

    public void addOuterJoinSuffix(String suffix) {
        if (suffix != null) {
            this.st.append(suffix);
        }
    }

    public ScalarExpression cast(Class castType) {
        LogicSetExpression te = this.qs.getTableExpression(this.qs.getStoreManager().getDatastoreClass(castType.getName(), this.qs.getClassLoaderResolver()).getIdentifier());
        DatastoreClass dc = this.qs.getStoreManager().getDatastoreClass(castType.getName(), this.qs.getClassLoaderResolver());
        if (te == null) {
            DatastoreIdentifier jtRangeVar;
            LogicSetExpression jtTblExpr;
            IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
            String jtIdentifier = this.te.getAlias().getIdentifierName();
            if (castType != null && !castType.getName().equals(this.mapping.getType())) {
                String castTypeName = castType.getName();
                jtIdentifier = idFactory.newIdentifier(this.te.getAlias(), castTypeName.substring(castTypeName.lastIndexOf(46) + 1)).getIdentifierName();
            }
            if ((jtTblExpr = this.qs.getTableExpression(jtRangeVar = idFactory.newIdentifier(IdentifierType.TABLE, jtIdentifier))) == null) {
                jtTblExpr = this.qs.newTableExpression(dc, jtRangeVar);
            }
            te = jtTblExpr;
            this.qs.leftOuterJoin(this, dc.getIDMapping().newScalarExpression(this.qs, jtTblExpr), jtTblExpr, true, true);
        }
        ObjectExpression objectCast = new ObjectExpression(this.qs, dc.getIDMapping(), te);
        objectCast.conditionExpr = this.conditionExpr;
        return objectCast;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        BooleanExpression bExpr = null;
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                bExpr = bExpr == null ? expr.eq(this.expressionList.getExpression(i)) : bExpr.and(expr.eq(this.expressionList.getExpression(i)));
            }
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.expressionList.size() > 1 ? super.eq(expr) : new BooleanExpression(this, OP_EQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.eq(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                ScalarExpression source = this.expressionList.getExpression(i);
                ScalarExpression target = expr.expressionList.getExpression(i);
                bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
            }
        } else if (expr instanceof UnboundVariable) {
            if (((UnboundVariable)expr).getVariableType() == null) {
                ((UnboundVariable)expr).setVariableType(this.qs.getClassLoaderResolver().classForName(this.fieldType));
            }
            bExpr = expr.eq(this);
        } else {
            bExpr = expr instanceof BooleanBitColumnExpression ? null : super.eq(expr);
        }
        if (this.conditionExpr != null) {
            return new BooleanExpression(this.conditionExpr, OP_AND, bExpr);
        }
        return bExpr;
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        BooleanExpression bExpr = null;
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                bExpr = bExpr == null ? expr.eq(this.expressionList.getExpression(i)) : bExpr.and(expr.eq(this.expressionList.getExpression(i)));
            }
            bExpr = new BooleanExpression(OP_NOT, bExpr.encloseWithInParentheses());
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.expressionList.size() > 1 ? super.noteq(expr) : new BooleanExpression(this, OP_NOTEQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.noteq(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                ScalarExpression source = this.expressionList.getExpression(i);
                ScalarExpression target = expr.expressionList.getExpression(i);
                bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
            }
            bExpr = new BooleanExpression(OP_NOT, bExpr.encloseWithInParentheses());
        } else if (expr instanceof UnboundVariable) {
            if (((UnboundVariable)expr).getVariableType() == null) {
                ((UnboundVariable)expr).setVariableType(this.qs.getClassLoaderResolver().classForName(this.fieldType));
            }
            bExpr = expr.noteq(this);
        } else if (expr instanceof BooleanBitColumnExpression) {
            if (this.conditionExpr != null) {
                bExpr = new BooleanExpression(ScalarExpression.OP_NOT, this.conditionExpr);
            }
        } else {
            bExpr = super.noteq(expr);
        }
        if (this.conditionExpr != null) {
            return new BooleanExpression(this.conditionExpr, OP_AND, bExpr);
        }
        return bExpr;
    }

    private boolean literalIsValidForSimpleComparison(ScalarExpression expr) {
        return expr instanceof BooleanLiteral && this.mapping instanceof BooleanMapping || expr instanceof ByteLiteral && this.mapping instanceof ByteMapping || expr instanceof CharacterLiteral && this.mapping instanceof CharacterMapping || expr instanceof FloatingPointLiteral && (this.mapping instanceof FloatMapping || this.mapping instanceof DoubleMapping || this.mapping instanceof BigDecimalMapping) || expr instanceof IntegerLiteral && (this.mapping instanceof IntegerMapping || this.mapping instanceof LongMapping || this.mapping instanceof BigIntegerMapping) || this.mapping instanceof ShortMapping || expr instanceof SqlDateLiteral && this.mapping instanceof SqlDateMapping || expr instanceof SqlTimeLiteral && this.mapping instanceof SqlTimeMapping || expr instanceof SqlTimestampLiteral && this.mapping instanceof SqlTimestampMapping || expr instanceof StringLiteral && (this.mapping instanceof StringMapping || this.mapping instanceof CharacterMapping);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScalarExpression accessField(String subfieldName, boolean innerJoin) {
        DatastoreIdentifier jtRangeVar;
        LogicSetExpression jtTblExpr;
        DatastoreContainerObject table;
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        try {
            if (this.mapping instanceof EmbeddedMapping) {
                table = this.mapping.getDatastoreContainer();
                if (this.te.getMainTable().equals(table)) {
                    return this.te.newFieldExpression(this.fieldName + "." + subfieldName);
                }
            } else if (this.mapping instanceof PersistenceCapableMapping || this.mapping instanceof ReferenceMapping) {
                AbstractClassMetaData otherCmd = this.qs.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(this.mapping.getType(), clr);
                if (otherCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] cmds = this.qs.getStoreManager().getClassesManagingTableForClass(otherCmd, clr);
                    if (cmds == null) throw new NucleusUserException(LOCALISER.msg("037005", (Object)this.mapping.getMemberMetaData().getFullFieldName()));
                    if (cmds.length > 1) {
                        NucleusLogger.QUERY.warn(LOCALISER.msg("037006", (Object)this.mapping.getMemberMetaData().getFullFieldName(), (Object)cmds[0].getFullClassName()));
                    }
                    table = this.qs.getStoreManager().getDatastoreClass(cmds[0].getFullClassName(), clr);
                } else {
                    JavaTypeMapping[] subMappings;
                    AbstractMemberMetaData subfieldMetaData;
                    table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), clr);
                    ApiAdapter api = this.qs.getStoreManager().getApiAdapter();
                    if (this.fieldName != null && subfieldName != null && (subfieldMetaData = otherCmd.getMetaDataForMember(subfieldName)) != null && subfieldMetaData.isPrimaryKey() && !api.isPersistable(subfieldMetaData.getType()) && (subMappings = ((PersistenceCapableMapping)this.mapping).getJavaTypeMapping()).length == 1) {
                        return subMappings[0].newScalarExpression(this.qs, this.te);
                    }
                }
            } else {
                table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), clr);
            }
        }
        catch (ClassNotPersistenceCapableException cnpce) {
            return this.te.newFieldExpression(subfieldName);
        }
        if (this.fieldType != null && !this.fieldType.equals(this.mapping.getType())) {
            DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
            DiscriminatorMapping discriminatorMapping = (DiscriminatorMapping)table.getDiscriminatorMapping(false);
            if (dismd != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
                BooleanExpression discrExpr = this.booleanConditionForClassInDiscriminator(this.qs, this.fieldType, dismd, discriminatorMapping, this.te);
                for (String subCandidateType : this.qs.getStoreManager().getSubClassesForClass(this.fieldType, true, clr)) {
                    discrExpr.ior(this.booleanConditionForClassInDiscriminator(this.qs, subCandidateType, dismd, discriminatorMapping, this.te));
                }
                discrExpr.encloseWithInParentheses();
                this.qs.andCondition(discrExpr);
            }
        }
        if (this.te.getMainTable().equals(table) && this.usingRelatedTable && this.fieldName == null) {
            return this.te.newFieldExpression(subfieldName);
        }
        String jtIdentifier = this.te.getAlias().getIdentifierName();
        if (this.fieldName != null) {
            jtIdentifier = jtIdentifier + '.' + this.fieldName;
        }
        if (!subfieldName.equals("this")) {
            jtIdentifier = jtIdentifier + '.' + subfieldName;
        }
        if (this.castType != null && !this.castType.getName().equals(this.mapping.getType())) {
            String castTypeName = this.castType.getName();
            jtIdentifier = jtIdentifier + '.' + castTypeName.substring(castTypeName.lastIndexOf(46) + 1);
        }
        if ((jtTblExpr = this.qs.getTableExpression(jtRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(IdentifierType.TABLE, jtIdentifier))) == null) {
            if (this.te.getAlias().getIdentifierName().equalsIgnoreCase("this") && table == this.qs.getMainTableExpression().getMainTable() && this.fieldName == null) {
                return this.qs.getMainTableExpression().newFieldExpression(subfieldName);
            }
            jtTblExpr = this.qs.newTableExpression(table, jtRangeVar);
            ScalarExpression jtExpr = table.getIDMapping().newScalarExpression(this.qs, jtTblExpr);
            ScalarExpression expr = this.mapping.newScalarExpression(this.qs, this.te);
            if (this.mapping.isNullable()) {
                if (innerJoin) {
                    this.qs.innerJoin(jtExpr, expr, jtTblExpr, true, true);
                } else {
                    this.qs.leftOuterJoin(jtExpr, expr, jtTblExpr, true, true);
                }
            } else {
                this.qs.innerJoin(jtExpr, expr, jtTblExpr, true, true);
            }
        }
        if (!(this.mapping instanceof EmbeddedPCMapping)) return jtTblExpr.newFieldExpression(subfieldName);
        return jtTblExpr.newFieldExpression(this.fieldName + "." + subfieldName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BooleanExpression instanceOf(ScalarExpression expr) {
        DatastoreClass table;
        if (!(expr instanceof ClassExpression)) throw new NucleusUserException(LOCALISER.msg("037007", (Object)expr.getClass().getName()));
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        Class instanceofClass = ((ClassExpression)expr).getCls();
        Class fieldClass = clr.classForName(this.mapping.getType());
        if (!fieldClass.isAssignableFrom(instanceofClass) && !instanceofClass.isAssignableFrom(fieldClass)) {
            return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, false));
        }
        try {
            if (this.mapping instanceof EmbeddedMapping) {
                return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
            }
            if (this.mapping instanceof PersistenceCapableMapping || this.mapping instanceof ReferenceMapping) {
                AbstractClassMetaData fieldCmd = this.qs.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(this.mapping.getType(), clr);
                if (fieldCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] cmds = this.qs.getStoreManager().getClassesManagingTableForClass(fieldCmd, clr);
                    if (cmds == null) throw new NucleusUserException(LOCALISER.msg("037005", (Object)this.mapping.getMemberMetaData().getFullFieldName()));
                    if (cmds.length > 1) {
                        NucleusLogger.QUERY.warn(LOCALISER.msg("037006", (Object)this.mapping.getMemberMetaData().getFullFieldName(), (Object)cmds[0].getFullClassName()));
                    }
                    table = this.qs.getStoreManager().getDatastoreClass(cmds[0].getFullClassName(), clr);
                } else {
                    table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), clr);
                }
            } else {
                table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), clr);
            }
        }
        catch (ClassNotPersistenceCapableException cnpce) {
            return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
        DiscriminatorMapping discriminatorMapping = (DiscriminatorMapping)table.getDiscriminatorMapping(false);
        if (discriminatorMapping != null) {
            LogicSetExpression fieldTblExpr = null;
            if (this.fieldName == null) {
                fieldTblExpr = this.qs.getTableExpression(this.te.getAlias());
            } else {
                String fieldIdentifier = this.te.getAlias().getIdentifierName();
                DatastoreIdentifier fieldRangeVar = idFactory.newIdentifier(IdentifierType.TABLE, fieldIdentifier = fieldIdentifier + '.' + this.fieldName);
                fieldTblExpr = this.qs.getTableExpression(fieldRangeVar);
                if (fieldTblExpr == null) {
                    fieldTblExpr = this.qs.newTableExpression(table, fieldRangeVar);
                }
                ScalarExpression fieldExpr = table.getIDMapping().newScalarExpression(this.qs, fieldTblExpr);
                expr = this.mapping.newScalarExpression(this.qs, this.te);
                this.qs.innerJoin(fieldExpr, expr, fieldTblExpr, true, true);
            }
            BooleanExpression discrExpr = this.booleanConditionForClassInDiscriminator(this.qs, instanceofClass.getName(), dismd, discriminatorMapping, fieldTblExpr);
            for (String subCandidateType : this.qs.getStoreManager().getSubClassesForClass(instanceofClass.getName(), true, clr)) {
                discrExpr.ior(this.booleanConditionForClassInDiscriminator(this.qs, subCandidateType, dismd, discriminatorMapping, fieldTblExpr));
            }
            discrExpr.encloseWithInParentheses();
            return discrExpr;
        }
        if (!(table instanceof DatastoreClass)) return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
        DatastoreClass ct = table;
        if (ct.managesClass(instanceofClass.getName())) {
            return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        DatastoreClass instanceofTable = this.qs.getStoreManager().getDatastoreClass(instanceofClass.getName(), clr);
        String fieldIdentifier = this.te.getAlias().getIdentifierName();
        fieldIdentifier = this.fieldName == null ? fieldIdentifier + ".INST" : fieldIdentifier + '.' + this.fieldName;
        DatastoreIdentifier fieldRangeVar = idFactory.newIdentifier(IdentifierType.TABLE, fieldIdentifier);
        LogicSetExpression fieldTblExpr = this.qs.newTableExpression(instanceofTable, fieldRangeVar);
        ScalarExpression fieldExpr = table.getIDMapping().newScalarExpression(this.qs, this.te);
        expr = this.fieldName == null ? instanceofTable.getIDMapping().newScalarExpression(this.qs, fieldTblExpr) : this.mapping.newScalarExpression(this.qs, fieldTblExpr);
        this.qs.innerJoin(fieldExpr, expr, fieldTblExpr, true, true);
        return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
    }

    public void setFieldDefinition(String fieldName, String fieldType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    private BooleanExpression booleanConditionForClassInDiscriminator(QueryExpression stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, LogicSetExpression tableExpr) {
        String discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData targetCmd = stmt.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(className, stmt.getClassLoaderResolver());
            discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
        }
        ScalarExpression discrExpr = discriminatorMapping.newScalarExpression(stmt, tableExpr);
        ScalarExpression discrVal = discriminatorMapping.newLiteral(stmt, discriminatorValue);
        return discrExpr.eq(discrVal);
    }
}

