/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.fileSinkDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class FileSinkOperator
extends TerminalOperator<fileSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient RecordWriter outWriter;
    protected transient FileSystem fs;
    protected transient Path outPath;
    protected transient Path finalPath;
    protected transient Serializer serializer;
    protected transient BytesWritable commonKey = new BytesWritable();
    protected transient TableIdEnum tabIdEnum = null;
    private transient LongWritable row_count;
    protected transient boolean autoDelete = false;
    Writable recordValue;

    private void commit() throws IOException {
        if (!this.fs.rename(this.outPath, this.finalPath)) {
            throw new IOException("Unable to rename output to: " + this.finalPath);
        }
        this.LOG.info((Object)("Committed to output file: " + this.finalPath));
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.serializer = (Serializer)((Object)((fileSinkDesc)this.conf).getTableInfo().getDeserializerClass().newInstance());
            this.serializer.initialize(null, ((fileSinkDesc)this.conf).getTableInfo().getProperties());
            JobConf jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf, ExecDriver.class);
            int id = ((fileSinkDesc)this.conf).getDestTableId();
            if (id != 0 && id <= TableIdEnum.values().length) {
                String enumName = "TABLE_ID_" + String.valueOf(id) + "_ROWCOUNT";
                this.tabIdEnum = TableIdEnum.valueOf(enumName);
                this.row_count = new LongWritable();
                this.statsMap.put(this.tabIdEnum, this.row_count);
            }
            String specPath = ((fileSinkDesc)this.conf).getDirName();
            Path tmpPath = Utilities.toTempPath(specPath);
            String taskId = Utilities.getTaskId(hconf);
            this.fs = new Path(specPath).getFileSystem(hconf);
            this.finalPath = new Path(tmpPath, taskId);
            this.outPath = new Path(tmpPath, Utilities.toTempPath(taskId));
            this.LOG.info((Object)("Writing to temp file: FS " + this.outPath));
            HiveOutputFormat hiveOutputFormat = ((fileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
            Class<? extends Writable> outputClass = this.serializer.getSerializedClass();
            boolean isCompressed = ((fileSinkDesc)this.conf).getCompressed();
            Path parent = Utilities.toTempPath(specPath);
            this.finalPath = HiveFileFormatUtils.getOutputFormatFinalPath(parent, jc, hiveOutputFormat, isCompressed, this.finalPath);
            tableDesc tableInfo = ((fileSinkDesc)this.conf).getTableInfo();
            JobConf jc_output = jc;
            if (isCompressed) {
                String type;
                jc_output = new JobConf((Configuration)jc);
                String codecStr = ((fileSinkDesc)this.conf).getCompressCodec();
                if (codecStr != null && !codecStr.trim().equals("")) {
                    Class<?> codec = Class.forName(codecStr);
                    FileOutputFormat.setOutputCompressorClass((JobConf)jc_output, codec);
                }
                if ((type = ((fileSinkDesc)this.conf).getCompressType()) != null && !type.trim().equals("")) {
                    SequenceFile.CompressionType style = SequenceFile.CompressionType.valueOf((String)type);
                    SequenceFileOutputFormat.setOutputCompressionType((JobConf)jc, (SequenceFile.CompressionType)style);
                }
            }
            this.outWriter = FileSinkOperator.getRecordWriter(jc_output, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), this.outPath);
            this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, this.outPath);
            this.initializeChildren(hconf);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    public static RecordWriter getRecordWriter(JobConf jc, HiveOutputFormat<?, ?> hiveOutputFormat, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProp, Path outPath) throws IOException, HiveException {
        if (hiveOutputFormat != null) {
            return hiveOutputFormat.getHiveRecordWriter(jc, outPath, valueClass, isCompressed, tableProp, null);
        }
        return null;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.counterNameToEnum != null) {
            ++this.outputRows;
            if (this.outputRows % 1000L == 0L) {
                this.incrCounter(numOutputRowsCntr, this.outputRows);
                this.outputRows = 0L;
            }
        }
        try {
            if (this.reporter != null) {
                this.reporter.progress();
            }
            this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[tag]);
            if (this.row_count != null) {
                this.row_count.set(this.row_count.get() + 1L);
            }
            this.outWriter.write(this.recordValue);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            if (this.outWriter != null) {
                try {
                    this.outWriter.close(abort);
                    this.commit();
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        } else {
            try {
                this.outWriter.close(abort);
                if (!this.autoDelete) {
                    this.fs.delete(this.outPath, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return new String("FS");
    }

    @Override
    public void jobClose(Configuration hconf, boolean success) throws HiveException {
        try {
            if (this.conf != null) {
                String specPath = ((fileSinkDesc)this.conf).getDirName();
                this.fs = new Path(specPath).getFileSystem(hconf);
                Path tmpPath = Utilities.toTempPath(specPath);
                Path intermediatePath = new Path(tmpPath.getParent(), tmpPath.getName() + ".intermediate");
                Path finalPath = new Path(specPath);
                if (success) {
                    if (this.fs.exists(tmpPath)) {
                        this.LOG.info((Object)("Moving tmp dir: " + tmpPath + " to: " + intermediatePath));
                        Utilities.rename(this.fs, tmpPath, intermediatePath);
                        Utilities.removeTempOrDuplicateFiles(this.fs, intermediatePath);
                        this.LOG.info((Object)("Moving tmp dir: " + intermediatePath + " to: " + finalPath));
                        Utilities.renameOrMoveFiles(this.fs, intermediatePath, finalPath);
                    }
                } else {
                    this.fs.delete(tmpPath, true);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        super.jobClose(hconf, success);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    public static enum TableIdEnum {
        TABLE_ID_1_ROWCOUNT,
        TABLE_ID_2_ROWCOUNT,
        TABLE_ID_3_ROWCOUNT,
        TABLE_ID_4_ROWCOUNT,
        TABLE_ID_5_ROWCOUNT,
        TABLE_ID_6_ROWCOUNT,
        TABLE_ID_7_ROWCOUNT,
        TABLE_ID_8_ROWCOUNT,
        TABLE_ID_9_ROWCOUNT,
        TABLE_ID_10_ROWCOUNT,
        TABLE_ID_11_ROWCOUNT,
        TABLE_ID_12_ROWCOUNT,
        TABLE_ID_13_ROWCOUNT,
        TABLE_ID_14_ROWCOUNT,
        TABLE_ID_15_ROWCOUNT;

    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }
}

