/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.plan.createFunctionDesc;
import org.apache.hadoop.hive.ql.plan.dropFunctionDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class FunctionTask
extends Task<FunctionWork> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.FunctionTask");
    transient HiveConf conf;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan) {
        super.initialize(conf, queryPlan);
        this.conf = conf;
    }

    @Override
    public int execute() {
        createFunctionDesc createFunctionDesc2 = ((FunctionWork)this.work).getCreateFunctionDesc();
        if (createFunctionDesc2 != null) {
            return this.createFunction(createFunctionDesc2);
        }
        dropFunctionDesc dropFunctionDesc2 = ((FunctionWork)this.work).getDropFunctionDesc();
        if (dropFunctionDesc2 != null) {
            return this.dropFunction(dropFunctionDesc2);
        }
        return 0;
    }

    private int createFunction(createFunctionDesc createFunctionDesc2) {
        try {
            Class<?> udfClass = this.getUdfClass(createFunctionDesc2);
            if (UDF.class.isAssignableFrom(udfClass)) {
                FunctionRegistry.registerTemporaryUDF(createFunctionDesc2.getFunctionName(), udfClass, false);
                return 0;
            }
            if (GenericUDF.class.isAssignableFrom(udfClass)) {
                FunctionRegistry.registerTemporaryGenericUDF(createFunctionDesc2.getFunctionName(), udfClass);
                return 0;
            }
            if (GenericUDTF.class.isAssignableFrom(udfClass)) {
                FunctionRegistry.registerTemporaryGenericUDTF(createFunctionDesc2.getFunctionName(), udfClass);
                return 0;
            }
            if (UDAF.class.isAssignableFrom(udfClass)) {
                FunctionRegistry.registerTemporaryUDAF(createFunctionDesc2.getFunctionName(), udfClass);
                return 0;
            }
            if (GenericUDAFResolver.class.isAssignableFrom(udfClass)) {
                FunctionRegistry.registerTemporaryGenericUDAF(createFunctionDesc2.getFunctionName(), (GenericUDAFResolver)ReflectionUtils.newInstance(udfClass, null));
                return 0;
            }
            return 1;
        }
        catch (ClassNotFoundException e) {
            LOG.info((Object)("create function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private int dropFunction(dropFunctionDesc dropFunctionDesc2) {
        try {
            FunctionRegistry.unregisterTemporaryUDF(dropFunctionDesc2.getFunctionName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info((Object)("drop function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private Class<?> getUdfClass(createFunctionDesc desc) throws ClassNotFoundException {
        return Class.forName(desc.getClassName(), true, JavaUtils.getClassLoader());
    }

    @Override
    public StageType getType() {
        return StageType.FUNC;
    }
}

