/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.GraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class DefaultGraphWalker
implements GraphWalker {
    protected Stack<Node> opStack;
    private List<Node> toWalk = new ArrayList<Node>();
    private Set<Node> seenList = new HashSet<Node>();
    private HashMap<Node, Object> retMap = new HashMap();
    private Dispatcher dispatcher;

    public DefaultGraphWalker(Dispatcher disp) {
        this.dispatcher = disp;
        this.opStack = new Stack();
    }

    public List<Node> getToWalk() {
        return this.toWalk;
    }

    public Set<Node> getDispatchedList() {
        return this.retMap.keySet();
    }

    public void dispatch(Node nd, Stack<Node> ndStack) throws SemanticException {
        Object[] nodeOutputs = null;
        if (nd.getChildren() != null) {
            nodeOutputs = new Object[nd.getChildren().size()];
            int i = 0;
            for (Node node : nd.getChildren()) {
                nodeOutputs[i++] = this.retMap.get(node);
            }
        }
        Object retVal = this.dispatcher.dispatch(nd, ndStack, nodeOutputs);
        this.retMap.put(nd, retVal);
    }

    @Override
    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        while (this.toWalk.size() > 0) {
            Node nd = this.toWalk.remove(0);
            this.walk(nd);
            if (nodeOutput == null) continue;
            nodeOutput.put(nd, this.retMap.get(nd));
        }
    }

    public void walk(Node nd) throws SemanticException {
        if (this.opStack.empty() || nd != this.opStack.peek()) {
            this.opStack.push(nd);
        }
        if (nd.getChildren() == null || this.getDispatchedList().containsAll(nd.getChildren())) {
            if (this.getDispatchedList().contains(nd)) assert (false);
            this.dispatch(nd, this.opStack);
            this.opStack.pop();
            return;
        }
        this.getToWalk().add(0, nd);
        this.getToWalk().removeAll(nd.getChildren());
        this.getToWalk().addAll(0, nd.getChildren());
    }
}

