/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class DefaultRuleDispatcher
implements Dispatcher {
    private Map<Rule, NodeProcessor> procRules;
    private NodeProcessorCtx procCtx;
    private NodeProcessor defaultProc;

    public DefaultRuleDispatcher(NodeProcessor defaultProc, Map<Rule, NodeProcessor> rules, NodeProcessorCtx procCtx) {
        this.defaultProc = defaultProc;
        this.procRules = rules;
        this.procCtx = procCtx;
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> ndStack, Object ... nodeOutputs) throws SemanticException {
        Rule rule = null;
        int minCost = Integer.MAX_VALUE;
        for (Rule r : this.procRules.keySet()) {
            int cost = r.cost(ndStack);
            if (cost < 0 || cost > minCost) continue;
            minCost = cost;
            rule = r;
        }
        NodeProcessor proc = rule == null ? this.defaultProc : this.procRules.get(rule);
        if (proc != null) {
            return proc.process(nd, ndStack, this.procCtx, nodeOutputs);
        }
        return null;
    }
}

