/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpProcFactory;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpWalkerCtx;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.exprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class PartitionPruner
implements Transform {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.optimizer.ppr.PartitionPruner");

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        OpWalkerCtx opWalkerCtx = new OpWalkerCtx(pctx.getOpToPartPruner());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "(TS%FIL%)|(TS%FIL%FIL%)"), OpProcFactory.getFilterProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(OpProcFactory.getDefaultProc(), opRules, opWalkerCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        pctx.setHasNonPartCols(opWalkerCtx.getHasNonPartCols());
        return pctx;
    }

    public static boolean onlyContainsPartnCols(Table tab, exprNodeDesc expr) {
        if (!tab.isPartitioned() || expr == null) {
            return true;
        }
        if (expr instanceof exprNodeColumnDesc) {
            String colName = ((exprNodeColumnDesc)expr).getColumn();
            return tab.isPartitionKey(colName);
        }
        if (expr instanceof exprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((exprNodeGenericFuncDesc)expr).getGenericUDF())) {
            return false;
        }
        List<exprNodeDesc> children = expr.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (PartitionPruner.onlyContainsPartnCols(tab, children.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static PrunedPartitionList prune(Table tab, exprNodeDesc prunerExpr, HiveConf conf, String alias, Map<String, PrunedPartitionList> prunedPartitionsMap) throws HiveException {
        PrunedPartitionList ret;
        LOG.trace((Object)"Started pruning partiton");
        LOG.trace((Object)("tabname = " + tab.getName()));
        LOG.trace((Object)("prune Expression = " + prunerExpr));
        String key = tab.getName() + ";";
        if (prunerExpr != null) {
            key = key + prunerExpr.getExprString();
        }
        if ((ret = prunedPartitionsMap.get(key)) != null) {
            return ret;
        }
        LinkedHashSet<Partition> true_parts = new LinkedHashSet<Partition>();
        LinkedHashSet<Partition> unkn_parts = new LinkedHashSet<Partition>();
        LinkedHashSet<Partition> denied_parts = new LinkedHashSet<Partition>();
        try {
            StructObjectInspector rowObjectInspector = (StructObjectInspector)tab.getDeserializer().getObjectInspector();
            Object[] rowWithPart = new Object[2];
            if (tab.isPartitioned()) {
                for (String partName : Hive.get().getPartitionNames(tab.getDbName(), tab.getName(), (short)-1)) {
                    LinkedHashMap partSpec = Warehouse.makeSpecFromName((String)partName);
                    ArrayList<String> partNames = new ArrayList<String>();
                    ArrayList partValues = new ArrayList();
                    ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>();
                    for (Map.Entry entry : partSpec.entrySet()) {
                        partNames.add((String)entry.getKey());
                        partValues.add(entry.getValue());
                        partObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                    }
                    StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
                    rowWithPart[1] = partValues;
                    ArrayList<StructObjectInspector> ois = new ArrayList<StructObjectInspector>(2);
                    ois.add(rowObjectInspector);
                    ois.add(partObjectInspector);
                    UnionStructObjectInspector rowWithPartObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(ois);
                    if ("strict".equalsIgnoreCase(HiveConf.getVar(conf, HiveConf.ConfVars.HIVEMAPREDMODE)) && !PartitionPruner.hasColumnExpr(prunerExpr)) {
                        throw new SemanticException(ErrorMsg.NO_PARTITION_PREDICATE.getMsg("for Alias \"" + alias + "\" Table \"" + tab.getName() + "\""));
                    }
                    if (prunerExpr != null) {
                        Partition part;
                        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(prunerExpr);
                        ObjectInspector evaluateResultOI = evaluator.initialize(rowWithPartObjectInspector);
                        Object evaluateResultO = evaluator.evaluate(rowWithPart);
                        Boolean r = (Boolean)((PrimitiveObjectInspector)evaluateResultOI).getPrimitiveJavaObject(evaluateResultO);
                        LOG.trace((Object)("prune result for partition " + partSpec + ": " + r));
                        if (Boolean.FALSE.equals(r)) {
                            if (denied_parts.isEmpty()) {
                                part = Hive.get().getPartition(tab, partSpec, Boolean.FALSE);
                                denied_parts.add(part);
                            }
                            LOG.trace((Object)("pruned partition: " + partSpec));
                            continue;
                        }
                        part = Hive.get().getPartition(tab, partSpec, Boolean.FALSE);
                        if (Boolean.TRUE.equals(r)) {
                            LOG.debug((Object)("retained partition: " + partSpec));
                            true_parts.add(part);
                            continue;
                        }
                        LOG.debug((Object)("unknown partition: " + partSpec));
                        unkn_parts.add(part);
                        continue;
                    }
                    true_parts.add(Hive.get().getPartition(tab, partSpec, Boolean.FALSE));
                }
            } else {
                true_parts.addAll(Hive.get().getPartitions(tab));
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ret = new PrunedPartitionList(true_parts, unkn_parts, denied_parts);
        prunedPartitionsMap.put(key, ret);
        return ret;
    }

    public static boolean hasColumnExpr(exprNodeDesc desc) {
        if (desc == null) {
            return false;
        }
        if (desc instanceof exprNodeColumnDesc) {
            return true;
        }
        List<exprNodeDesc> children = desc.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (!PartitionPruner.hasColumnExpr(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

