/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ddlDesc;
import org.apache.hadoop.hive.ql.plan.explain;

@explain(displayName="Alter Table")
public class alterTableDesc
extends ddlDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    alterTableTypes op;
    String oldName;
    String newName;
    List<FieldSchema> newCols;
    String serdeName;
    Map<String, String> props;
    String inputFormat;
    String outputFormat;
    int numberBuckets;
    List<String> bucketColumns;
    List<Order> sortColumns;
    String oldColName;
    String newColName;
    String newColType;
    String newColComment;
    boolean first;
    String afterCol;

    public alterTableDesc(String tblName, String oldColName, String newColName, String newType, String newComment, boolean first, String afterCol) {
        this.oldName = tblName;
        this.oldColName = oldColName;
        this.newColName = newColName;
        this.newColType = newType;
        this.newColComment = newComment;
        this.first = first;
        this.afterCol = afterCol;
        this.op = alterTableTypes.RENAMECOLUMN;
    }

    public alterTableDesc(String oldName, String newName) {
        this.op = alterTableTypes.RENAME;
        this.oldName = oldName;
        this.newName = newName;
    }

    public alterTableDesc(String name, List<FieldSchema> newCols, alterTableTypes alterType) {
        this.op = alterType;
        this.oldName = name;
        this.newCols = newCols;
    }

    public alterTableDesc(alterTableTypes alterType) {
        this.op = alterType;
    }

    public alterTableDesc(String name, String inputFormat, String outputFormat, String serdeName) {
        this.op = alterTableTypes.ADDFILEFORMAT;
        this.oldName = name;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serdeName = serdeName;
    }

    public alterTableDesc(String tableName, int numBuckets, List<String> bucketCols, List<Order> sortCols) {
        this.oldName = tableName;
        this.op = alterTableTypes.ADDCLUSTERSORTCOLUMN;
        this.numberBuckets = numBuckets;
        this.bucketColumns = bucketCols;
        this.sortColumns = sortCols;
    }

    @explain(displayName="old name")
    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    @explain(displayName="new name")
    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public alterTableTypes getOp() {
        return this.op;
    }

    @explain(displayName="type")
    public String getAlterTableTypeString() {
        switch (this.op) {
            case RENAME: {
                return "rename";
            }
            case ADDCOLS: {
                return "add columns";
            }
            case REPLACECOLS: {
                return "replace columns";
            }
        }
        return "unknown";
    }

    public void setOp(alterTableTypes op) {
        this.op = op;
    }

    public List<FieldSchema> getNewCols() {
        return this.newCols;
    }

    @explain(displayName="new columns")
    public List<String> getNewColsString() {
        return Utilities.getFieldSchemaString(this.getNewCols());
    }

    public void setNewCols(List<FieldSchema> newCols) {
        this.newCols = newCols;
    }

    @explain(displayName="deserializer library")
    public String getSerdeName() {
        return this.serdeName;
    }

    public void setSerdeName(String serdeName) {
        this.serdeName = serdeName;
    }

    @explain(displayName="properties")
    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public int getNumberBuckets() {
        return this.numberBuckets;
    }

    public void setNumberBuckets(int numberBuckets) {
        this.numberBuckets = numberBuckets;
    }

    public List<String> getBucketColumns() {
        return this.bucketColumns;
    }

    public void setBucketColumns(List<String> bucketColumns) {
        this.bucketColumns = bucketColumns;
    }

    public List<Order> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(List<Order> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public String getOldColName() {
        return this.oldColName;
    }

    public void setOldColName(String oldColName) {
        this.oldColName = oldColName;
    }

    public String getNewColName() {
        return this.newColName;
    }

    public void setNewColName(String newColName) {
        this.newColName = newColName;
    }

    public String getNewColType() {
        return this.newColType;
    }

    public void setNewColType(String newType) {
        this.newColType = newType;
    }

    public String getNewColComment() {
        return this.newColComment;
    }

    public void setNewColComment(String newComment) {
        this.newColComment = newComment;
    }

    public boolean getFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public String getAfterCol() {
        return this.afterCol;
    }

    public void setAfterCol(String afterCol) {
        this.afterCol = afterCol;
    }

    public static enum alterTableTypes {
        RENAME,
        ADDCOLS,
        REPLACECOLS,
        ADDPROPS,
        ADDSERDE,
        ADDSERDEPROPS,
        ADDFILEFORMAT,
        ADDCLUSTERSORTCOLUMN,
        RENAMECOLUMN;

    }
}

