/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@description(name="abs", value="_FUNC_(x) - returns the absolute value of x", extended="Example:\n  > SELECT _FUNC_(0) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(-5) FROM src LIMIT 1;\n  5")
public class UDFAbs
extends UDF {
    private DoubleWritable resultDouble = new DoubleWritable();
    private LongWritable resultLong = new LongWritable();
    private IntWritable resultInt = new IntWritable();

    public DoubleWritable evaluate(DoubleWritable n) {
        if (n == null) {
            return null;
        }
        this.resultDouble.set(Math.abs(n.get()));
        return this.resultDouble;
    }

    public LongWritable evaluate(LongWritable n) {
        if (n == null) {
            return null;
        }
        this.resultLong.set(Math.abs(n.get()));
        return this.resultLong;
    }

    public IntWritable evaluate(IntWritable n) {
        if (n == null) {
            return null;
        }
        this.resultInt.set(Math.abs(n.get()));
        return this.resultInt;
    }
}

