/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="conv", value="_FUNC_(num, from_base, to_base) - convert num from from_base to to_base", extended="If to_base is negative, treat num as a signed integer,otherwise, treat it as an unsigned integer.\nExample:\n  > SELECT _FUNC_('100', 2, 10) FROM src LIMIT 1;\n  '4'\n  > SELECT _FUNC_(-10, 16, -10) FROM src LIMIT 1;\n  '16'")
public class UDFConv
extends UDF {
    private Text result = new Text();
    private byte[] value = new byte[64];

    private long unsignedLongDiv(long x, int m) {
        if (x >= 0L) {
            return x / (long)m;
        }
        return x / (long)m + 2L * (Long.MAX_VALUE / (long)m) + (long)(2 / m) + (x % (long)m + 2L * (Long.MAX_VALUE % (long)m) + (long)(2 % m)) / (long)m;
    }

    private void decode(long val, int radix) {
        Arrays.fill(this.value, (byte)0);
        int i = this.value.length - 1;
        while (val != 0L) {
            long q = this.unsignedLongDiv(val, radix);
            this.value[i] = (byte)(val - q * (long)radix);
            val = q;
            --i;
        }
    }

    private long encode(int radix) {
        long val = 0L;
        long bound = this.unsignedLongDiv(-1 - radix, radix);
        for (int i = 0; i < this.value.length && this.value[i] >= 0; ++i) {
            if (val >= bound && this.unsignedLongDiv(-1 - this.value[i], radix) < val) {
                return -1L;
            }
            val = val * (long)radix + (long)this.value[i];
        }
        return val;
    }

    private void byte2char(int radix, int fromPos) {
        for (int i = fromPos; i < this.value.length; ++i) {
            this.value[i] = (byte)Character.toUpperCase(Character.forDigit(this.value[i], radix));
        }
    }

    private void char2byte(int radix, int fromPos) {
        for (int i = fromPos; i < this.value.length; ++i) {
            this.value[i] = (byte)Character.digit(this.value[i], radix);
        }
    }

    public Text evaluate(Text n, IntWritable fromBase, IntWritable toBase) {
        if (n == null || fromBase == null || toBase == null) {
            return null;
        }
        int fromBs = fromBase.get();
        int toBs = toBase.get();
        if (fromBs < 2 || fromBs > 36 || Math.abs(toBs) < 2 || Math.abs(toBs) > 36) {
            return null;
        }
        byte[] num = n.getBytes();
        boolean negative = num[0] == 45;
        int first = 0;
        if (negative) {
            first = 1;
        }
        for (int i = 1; i <= n.getLength() - first; ++i) {
            this.value[this.value.length - i] = num[n.getLength() - i];
        }
        this.char2byte(fromBs, this.value.length - n.getLength() + first);
        long val = this.encode(fromBs);
        if (negative && toBs > 0) {
            val = val < 0L ? -1L : -val;
        }
        if (toBs < 0 && val < 0L) {
            val = -val;
            negative = true;
        }
        this.decode(val, Math.abs(toBs));
        for (first = 0; first < this.value.length - 1 && this.value[first] == 0; ++first) {
        }
        this.byte2char(Math.abs(toBs), first);
        if (negative && toBs < 0) {
            this.value[--first] = 45;
        }
        this.result.set(this.value, first, this.value.length - first);
        return this.result;
    }
}

